/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import water.H2O;
import water.exceptions.JCodeSB;
import water.util.IcedBitSet;

public final class SB
implements JCodeSB<SB> {
    public final boolean _outputDoubles = H2O.getSysBoolProperty("java.output.doubles", false);
    public final StringBuilder _sb;
    int _indent = 0;
    public static final Pattern[] ILLEGAL_CHARACTERS = new Pattern[]{Pattern.compile("\\", 16), Pattern.compile("\"", 16)};
    public static final String[] REPLACEMENTS = new String[]{"\\\\\\\\", "\\\\\""};

    public SB() {
        this._sb = new StringBuilder();
    }

    public SB(String s2) {
        this._sb = new StringBuilder(s2);
    }

    @Override
    public SB ps(String s2) {
        this._sb.append("\"");
        this.pj(s2);
        this._sb.append("\"");
        return this;
    }

    @Override
    public SB p(String s2) {
        this._sb.append(s2);
        return this;
    }

    private SB p(float s2) {
        if (Float.isNaN(s2)) {
            this._sb.append("Float.NaN");
        } else if (Float.isInfinite(s2)) {
            this._sb.append(s2 > 0.0f ? "Float.POSITIVE_INFINITY" : "Float.NEGATIVE_INFINITY");
        } else {
            this._sb.append(s2);
        }
        return this;
    }

    @Override
    public SB p(double s2) {
        if (Double.isNaN(s2)) {
            this._sb.append("Double.NaN");
        } else if (Double.isInfinite(s2)) {
            this._sb.append(s2 > 0.0 ? "Double.POSITIVE_INFINITY" : "Double.NEGATIVE_INFINITY");
        } else {
            this._sb.append(s2);
        }
        return this;
    }

    @Override
    public SB p(char s2) {
        this._sb.append(s2);
        return this;
    }

    @Override
    public SB p(int s2) {
        this._sb.append(s2);
        return this;
    }

    @Override
    public SB p(long s2) {
        this._sb.append(s2);
        return this;
    }

    @Override
    public SB p(boolean s2) {
        this._sb.append(s2);
        return this;
    }

    @Override
    public SB pobj(Object s2) {
        this._sb.append(s2.toString());
        return this;
    }

    @Override
    public SB i(int d2) {
        for (int i2 = 0; i2 < d2 + this._indent; ++i2) {
            this.p("  ");
        }
        return this;
    }

    @Override
    public SB i() {
        return this.i(0);
    }

    @Override
    public SB ip(String s2) {
        return this.i().p(s2);
    }

    @Override
    public SB s() {
        this._sb.append(' ');
        return this;
    }

    @Override
    public SB pj(double s2) {
        if (Double.isInfinite(s2)) {
            this._sb.append("Double.").append(s2 > 0.0 ? "POSITIVE_INFINITY" : "NEGATIVE_INFINITY");
        } else if (Double.isNaN(s2)) {
            this._sb.append("Double.NaN");
        } else {
            this._sb.append(s2);
        }
        return this;
    }

    @Override
    public SB pj(float s2) {
        if (this._outputDoubles) {
            return this.pj((double)s2);
        }
        if (Float.isInfinite(s2)) {
            this._sb.append("Float.").append(s2 > 0.0f ? "POSITIVE_INFINITY" : "NEGATIVE_INFINITY");
        } else if (Float.isNaN(s2)) {
            this._sb.append("Float.NaN");
        } else {
            this._sb.append(s2).append('f');
        }
        return this;
    }

    @Override
    public SB pj(String s2) {
        this._sb.append(SB.escapeJava(s2));
        return this;
    }

    @Override
    public SB pj(String objectName, String fieldName) {
        this._sb.append(objectName).append('.').append(fieldName);
        return this;
    }

    @Override
    public SB p(IcedBitSet ibs) {
        return ibs.toString(this);
    }

    @Override
    public SB ii(int i2) {
        this._indent += i2;
        return this;
    }

    @Override
    public SB di(int i2) {
        this._indent -= i2;
        return this;
    }

    @Override
    public SB ci(JCodeSB sb) {
        this._indent = sb.getIndent();
        return this;
    }

    @Override
    public SB nl() {
        return this.p('\n');
    }

    @Override
    public SB toJavaStringInit(String[] ss) {
        if (ss == null) {
            return this.p("null");
        }
        this.p('{');
        for (int i2 = 0; i2 < ss.length - 1; ++i2) {
            this.p('\"').pj(ss[i2]).p("\",");
        }
        if (ss.length > 0) {
            this.p('\"').pj(ss[ss.length - 1]).p('\"');
        }
        return this.p('}');
    }

    @Override
    public SB toJavaStringInit(float[] ss) {
        if (ss == null) {
            return this.p("null");
        }
        this.p('{');
        for (int i2 = 0; i2 < ss.length - 1; ++i2) {
            this.pj(ss[i2]).p(',');
        }
        if (ss.length > 0) {
            this.pj(ss[ss.length - 1]);
        }
        return this.p('}');
    }

    @Override
    public SB toJavaStringInit(double[] ss) {
        if (ss == null) {
            return this.p("null");
        }
        this.p('{');
        for (int i2 = 0; i2 < ss.length - 1; ++i2) {
            this.pj(ss[i2]).p(',');
        }
        if (ss.length > 0) {
            this.pj(ss[ss.length - 1]);
        }
        return this.p('}');
    }

    @Override
    public SB toJavaStringInit(double[][] ss) {
        if (ss == null) {
            return this.p("null");
        }
        this.p('{');
        for (int i2 = 0; i2 < ss.length - 1; ++i2) {
            this.toJavaStringInit(ss[i2]).p(',');
        }
        if (ss.length > 0) {
            this.toJavaStringInit(ss[ss.length - 1]);
        }
        return this.p('}');
    }

    @Override
    public SB toJavaStringInit(double[][][] ss) {
        if (ss == null) {
            return this.p("null");
        }
        this.p('{');
        for (int i2 = 0; i2 < ss.length - 1; ++i2) {
            this.toJavaStringInit(ss[i2]).p(',');
        }
        if (ss.length > 0) {
            this.toJavaStringInit(ss[ss.length - 1]);
        }
        return this.p('}');
    }

    @Override
    public SB toJSArray(float[] nums) {
        this.p('[');
        for (int i2 = 0; i2 < nums.length; ++i2) {
            if (i2 > 0) {
                this.p(',');
            }
            this.p(nums[i2]);
        }
        return this.p(']');
    }

    @Override
    public SB toJSArray(String[] ss) {
        this.p('[');
        for (int i2 = 0; i2 < ss.length; ++i2) {
            if (i2 > 0) {
                this.p(',');
            }
            this.p('\"').p(ss[i2]).p('\"');
        }
        return this.p(']');
    }

    @Override
    public int getIndent() {
        return this._indent;
    }

    @Override
    public SB p(JCodeSB sb) {
        this._sb.append(sb.getContent());
        return this;
    }

    public String toString() {
        return this._sb.toString();
    }

    public static String escapeJava(String s2) {
        assert (ILLEGAL_CHARACTERS.length == REPLACEMENTS.length);
        for (int i2 = 0; i2 < ILLEGAL_CHARACTERS.length; ++i2) {
            Matcher m4 = ILLEGAL_CHARACTERS[i2].matcher(s2);
            s2 = m4.replaceAll(REPLACEMENTS[i2]);
        }
        return s2;
    }

    @Override
    public String getContent() {
        return this._sb.toString();
    }
}

