/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.util.Arrays;

public class SetOfBytes {
    private boolean[] bits = new boolean[256];

    public SetOfBytes(byte[] bytes) {
        for (byte b2 : bytes) {
            this.bits[0xFF & b2] = true;
        }
    }

    public SetOfBytes(String s2) {
        this(s2.getBytes());
    }

    public boolean contains(int b2) {
        return b2 < 256 && b2 > -129 && this.bits[0xFF & b2];
    }

    public boolean equals(Object other) {
        return other instanceof SetOfBytes && Arrays.equals(this.bits, ((SetOfBytes)other).bits);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bits);
    }

    public int size() {
        int n2 = 0;
        for (int b2 = 0; b2 < 256; ++b2) {
            if (!this.bits[b2]) continue;
            ++n2;
        }
        return n2;
    }

    public byte[] getBytes() {
        byte[] out = new byte[this.size()];
        int i2 = 0;
        for (int b2 = 0; b2 < 256; ++b2) {
            if (!this.bits[b2]) continue;
            out[i2++] = (byte)b2;
        }
        return out;
    }

    public String toString() {
        return "SetOfBytes(" + Arrays.toString(this.getBytes()) + ")";
    }
}

