/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import hex.Interaction;
import water.Iced;
import water.Job;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.AtomicUtils;
import water.util.Log;
import water.util.TwoDimTable;

public class Tabulate
extends Keyed<Tabulate> {
    public final Job<Tabulate> _job;
    public Frame _dataset;
    public Key[] _vecs = new Key[2];
    public String _predictor;
    public String _response;
    public String _weight;
    int _nbins_predictor = 20;
    int _nbins_response = 10;
    double[][] _count_data;
    double[][] _response_data;
    public TwoDimTable _count_table;
    public TwoDimTable _response_table;
    private final Stats[] _stats = new Stats[2];

    public Tabulate() {
        this._job = new Job(Key.make(), Tabulate.class.getName(), "Tabulate job");
    }

    private int bins(int v2) {
        return v2 == 1 ? this._nbins_response : this._nbins_predictor;
    }

    private int res(int v2) {
        int missing = this._stats[v2]._missing;
        if (this._stats[v2]._isCategorical) {
            return this._stats[v2]._cardinality + missing;
        }
        return this.bins(v2) + missing;
    }

    private int bin(int v2, double val) {
        int b2;
        if (Double.isNaN(val)) {
            return 0;
        }
        int bins = this.bins(v2);
        if (this._stats[v2]._isCategorical) {
            assert ((double)((int)val) == val);
            b2 = (int)val;
        } else {
            double d2 = (this._stats[v2]._max - this._stats[v2]._min) / (double)bins;
            b2 = (int)((val - this._stats[v2]._min) / d2);
            assert (b2 >= 0 && b2 <= bins);
            b2 = Math.min(b2, bins - 1);
        }
        return b2 + this._stats[v2]._missing;
    }

    private String labelForBin(int v2, int b2) {
        int missing = this._stats[v2]._missing;
        if (missing == 1 && b2 == 0) {
            return "missing(NA)";
        }
        if (missing == 1) {
            --b2;
        }
        if (this._stats[v2]._isCategorical) {
            return this._stats[v2]._domain[b2];
        }
        int bins = this.bins(v2);
        if (this._stats[v2]._isInt && this._stats[v2]._max - this._stats[v2]._min + 1.0 <= (double)bins) {
            return Integer.toString((int)(this._stats[v2]._min + (double)b2));
        }
        double d2 = (this._stats[v2]._max - this._stats[v2]._min) / (double)bins;
        return String.format("%5f", this._stats[v2]._min + ((double)b2 + 0.5) * d2);
    }

    public Tabulate execImpl() {
        Vec w2;
        if (this._dataset == null) {
            throw new H2OIllegalArgumentException("Dataset not found");
        }
        if (this._nbins_predictor < 1) {
            throw new H2OIllegalArgumentException("Number of bins for predictor must be >= 1");
        }
        if (this._nbins_response < 1) {
            throw new H2OIllegalArgumentException("Number of bins for response must be >= 1");
        }
        Vec x2 = this._dataset.vec(this._predictor);
        if (x2 == null) {
            throw new H2OIllegalArgumentException("Predictor column " + this._predictor + " not found");
        }
        if (x2.cardinality() > this._nbins_predictor) {
            Interaction in = new Interaction();
            in._source_frame = this._dataset._key;
            in._factor_columns = new String[]{this._predictor};
            in._max_factors = this._nbins_predictor - 1;
            in.execImpl(null);
            x2 = ((Frame)in._job._result.get()).anyVec();
        } else if (x2.isInt() && x2.max() - x2.min() + 1.0 <= (double)this._nbins_predictor) {
            x2 = x2.toCategoricalVec();
        }
        Vec y2 = this._dataset.vec(this._response);
        if (y2 == null) {
            throw new H2OIllegalArgumentException("Response column " + this._response + " not found");
        }
        if (y2.cardinality() > this._nbins_response) {
            Interaction in = new Interaction();
            in._source_frame = this._dataset._key;
            in._factor_columns = new String[]{this._response};
            in._max_factors = this._nbins_response - 1;
            in.execImpl(null);
            y2 = ((Frame)in._job._result.get()).anyVec();
        } else if (y2.isInt() && y2.max() - y2.min() + 1.0 <= (double)this._nbins_response) {
            y2 = y2.toCategoricalVec();
        }
        if (y2 != null && y2.cardinality() > 2) {
            Log.warn("Response column has more than two factor levels - mean response depends on lexicographic order of factors!");
        }
        if ((w2 = this._dataset.vec(this._weight)) != null && !w2.isNumeric() && w2.min() < 0.0) {
            throw new H2OIllegalArgumentException("Observation weights must be numeric with values >= 0");
        }
        if (x2 != null) {
            this._vecs[0] = x2._key;
            this._stats[0] = new Stats(x2);
        }
        if (y2 != null) {
            this._vecs[1] = y2._key;
            this._stats[1] = new Stats(y2);
        }
        Tabulate sp2 = w2 != null ? ((CoOccurrence)new CoOccurrence((Tabulate)this).doAll((Vec[])new Vec[]{x2, y2, w2}))._sp : ((CoOccurrence)new CoOccurrence((Tabulate)this).doAll((Vec[])new Vec[]{x2, y2}))._sp;
        this._count_table = sp2.tabulationTwoDimTable();
        this._response_table = sp2.responseCharTwoDimTable();
        Log.info(this._count_table.toString(2, false));
        Log.info(this._response_table.toString(2, false));
        return sp2;
    }

    public TwoDimTable tabulationTwoDimTable() {
        if (this._response_data == null) {
            return null;
        }
        int predN = this._count_data.length;
        int respN = this._count_data[0].length;
        String tableHeader = "(Weighted) co-occurrence counts of '" + this._predictor + "' and '" + this._response + "'";
        String[] rowHeaders = new String[predN * respN];
        String[] colHeaders = new String[3];
        String[] colTypes = new String[colHeaders.length];
        String[] colFormats = new String[colHeaders.length];
        colHeaders[0] = this._predictor;
        colHeaders[1] = this._response;
        colTypes[0] = "string";
        colFormats[0] = "%s";
        colTypes[1] = "string";
        colFormats[1] = "%s";
        colHeaders[2] = "counts";
        colTypes[2] = "double";
        colFormats[2] = "%f";
        TwoDimTable table = new TwoDimTable(tableHeader, null, rowHeaders, colHeaders, colTypes, colFormats, null);
        for (int p2 = 0; p2 < predN; ++p2) {
            String plabel = this.labelForBin(0, p2);
            for (int r2 = 0; r2 < respN; ++r2) {
                String rlabel = this.labelForBin(1, r2);
                for (int c2 = 0; c2 < 3; ++c2) {
                    table.set(r2 * predN + p2, 0, plabel);
                    table.set(r2 * predN + p2, 1, rlabel);
                    table.set(r2 * predN + p2, 2, this._count_data[p2][r2]);
                }
            }
        }
        return table;
    }

    public TwoDimTable responseCharTwoDimTable() {
        if (this._response_data == null) {
            return null;
        }
        String tableHeader = "Mean value of '" + this._response + "' and (weighted) counts for '" + this._predictor + "' values";
        int predN = this._count_data.length;
        String[] rowHeaders = new String[predN];
        String[] colHeaders = new String[3];
        String[] colTypes = new String[colHeaders.length];
        String[] colFormats = new String[colHeaders.length];
        colHeaders[0] = this._predictor;
        colTypes[0] = "string";
        colFormats[0] = "%s";
        colHeaders[1] = "mean " + this._response;
        colTypes[2] = "double";
        colFormats[2] = "%f";
        colHeaders[2] = "counts";
        colTypes[1] = "double";
        colFormats[1] = "%f";
        TwoDimTable table = new TwoDimTable(tableHeader, null, rowHeaders, colHeaders, colTypes, colFormats, null);
        for (int p2 = 0; p2 < predN; ++p2) {
            String plabel = this.labelForBin(0, p2);
            table.set(p2, 0, plabel);
            table.set(p2, 1, this._response_data[p2][0]);
            table.set(p2, 2, this._response_data[p2][1]);
        }
        return table;
    }

    private static class CoOccurrence
    extends MRTask<CoOccurrence> {
        final Tabulate _sp;

        CoOccurrence(Tabulate sp2) {
            this._sp = sp2;
        }

        @Override
        protected void setupLocal() {
            this._sp._count_data = new double[this._sp.res(0)][this._sp.res(1)];
            this._sp._response_data = new double[this._sp.res(0)][2];
        }

        @Override
        public void map(Chunk x2, Chunk y2) {
            this.map(x2, y2, (Chunk)null);
        }

        @Override
        public void map(Chunk x2, Chunk y2, Chunk w2) {
            for (int r2 = 0; r2 < x2.len(); ++r2) {
                double weight;
                int xbin = this._sp.bin(0, x2.atd(r2));
                int ybin = this._sp.bin(1, y2.atd(r2));
                double d2 = weight = w2 != null ? w2.atd(r2) : 1.0;
                if (Double.isNaN(weight)) continue;
                AtomicUtils.DoubleArray.add(this._sp._count_data[xbin], ybin, weight);
                if (y2.isNA(r2)) continue;
                AtomicUtils.DoubleArray.add(this._sp._response_data[xbin], 0, weight * y2.atd(r2));
                AtomicUtils.DoubleArray.add(this._sp._response_data[xbin], 1, weight);
            }
        }

        @Override
        public void reduce(CoOccurrence mrt) {
            if (this._sp._response_data == mrt._sp._response_data) {
                return;
            }
            ArrayUtils.add(this._sp._response_data, mrt._sp._response_data);
        }

        @Override
        protected void postGlobal() {
            for (int i2 = 0; i2 < this._sp._response_data.length; ++i2) {
                double[] dArray = this._sp._response_data[i2];
                dArray[0] = dArray[0] / this._sp._response_data[i2][1];
            }
        }
    }

    private static class Stats
    extends Iced {
        final double _min;
        final double _max;
        final boolean _isCategorical;
        final boolean _isInt;
        final int _cardinality;
        final int _missing;
        final String[] _domain;

        Stats(Vec v2) {
            this._min = v2.min();
            this._max = v2.max();
            this._isCategorical = v2.isCategorical();
            this._isInt = v2.isInt();
            this._cardinality = v2.cardinality();
            this._missing = v2.naCnt() > 0L ? 1 : 0;
            this._domain = v2.domain();
        }
    }
}

