/*
 * Decompiled with CFR 0.152.
 */
package water.util.fp;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import water.util.fp.Function;

public class FP {
    public static final Option<?> None = new Option<Object>(){

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean nonEmpty() {
            return false;
        }

        @Override
        public <U> Option<U> flatMap(Function<Object, Option<U>> f2) {
            return None;
        }

        @Override
        public Iterator<Object> iterator() {
            return Collections.emptyList().iterator();
        }

        public String toString() {
            return "None";
        }

        public int hashCode() {
            return -1;
        }
    };

    public static boolean equal(Object a2, Object b2) {
        return a2 == b2 || a2 != null && a2.equals(b2);
    }

    public static int hashCode(Object o2) {
        return o2 != null ? o2.hashCode() : 0;
    }

    public static <T> Option<T> Some(T t2) {
        return new Some<T>(t2);
    }

    public static <T> Option<T> Option(T t2) {
        return t2 == null ? None : new Some<T>(t2);
    }

    public static <T> Option<T> flatten(Option<Option<T>> optOptT) {
        return optOptT.isEmpty() ? None : (Option)((Some)optOptT).get();
    }

    public static <T> Option<T> headOption(Iterator<T> it) {
        return FP.Option(it.hasNext() ? (T)it.next() : null);
    }

    public static <T> Option<T> headOption(Iterable<T> ts) {
        return FP.headOption(ts.iterator());
    }

    public static final class Some<T>
    implements Option<T> {
        private List<T> contents;

        public Some(T t2) {
            this.contents = Collections.singletonList(t2);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean nonEmpty() {
            return true;
        }

        @Override
        public <U> Option<U> flatMap(Function<T, Option<U>> f2) {
            return f2.apply(this.get());
        }

        @Override
        public Iterator<T> iterator() {
            return this.contents.iterator();
        }

        public T get() {
            return this.contents.get(0);
        }

        public String toString() {
            return "Some(" + this.get() + ")";
        }

        public boolean equals(Object o2) {
            return this == o2 || o2 instanceof Some && FP.equal(this.get(), ((Some)o2).get());
        }

        public int hashCode() {
            return FP.hashCode(this.get());
        }
    }

    static interface Option<T>
    extends Iterable<T> {
        public boolean isEmpty();

        public boolean nonEmpty();

        public <U> Option<U> flatMap(Function<T, Option<U>> var1);
    }
}

