/*
 * Decompiled with CFR 0.152.
 */
package water.util.fp;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import water.util.fp.Function;
import water.util.fp.Unfoldable;

public class Functions {
    public static <X, Y, Z> Function<X, Z> compose(Function<Y, Z> g2, Function<X, Y> f2) {
        return new Composition<X, Y, Z>(f2, g2);
    }

    public static <X> Function<X, X> identity() {
        return new Function<X, X>(){

            @Override
            public X apply(X x2) {
                return x2;
            }
        };
    }

    public static <T> Function<Long, T> onList(final List<T> list) {
        return new Function<Long, T>(){

            @Override
            public T apply(Long i2) {
                return list.get(i2.intValue());
            }
        };
    }

    public static <X, Y> Iterable<Y> map(Iterable<X> xs, Function<X, Y> f2) {
        LinkedList<Y> ys = new LinkedList<Y>();
        for (X x2 : xs) {
            ys.add(f2.apply(x2));
        }
        return ys;
    }

    public static <X, Y> Function<X, Y> constant(final Y y2) {
        return new Function<X, Y>(){

            @Override
            public Y apply(X x2) {
                return y2;
            }
        };
    }

    public static Unfoldable<String, String> splitBy(String separator) {
        return new StringSplitter(separator);
    }

    public static double integrate(Function<Integer, Double> x2, Function<Integer, Double> y2, int from, int to) {
        double s2 = 0.0;
        double x0 = x2.apply(from);
        double y0 = y2.apply(from);
        for (int i2 = from + 1; i2 <= to; ++i2) {
            double x1 = x2.apply(i2);
            double y1 = y2.apply(i2);
            s2 += (y1 + y0) * (x1 - x0) * 0.5;
            x0 = x1;
            y0 = y1;
        }
        return s2;
    }

    static class StringSplitter
    implements Unfoldable<String, String> {
        private final String separator;

        StringSplitter(String separator) {
            this.separator = separator;
        }

        @Override
        public List<String> apply(String s2) {
            return Arrays.asList(s2.split(this.separator));
        }

        public int hashCode() {
            return 211 + this.separator.hashCode() * 7;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StringSplitter)) {
                return false;
            }
            StringSplitter other = (StringSplitter)obj;
            return Objects.equals(this.separator, other.separator);
        }
    }

    static class Composition<X, Y, Z>
    implements Function<X, Z> {
        private final Function<X, Y> f;
        private final Function<Y, Z> g;

        Composition(Function<X, Y> f2, Function<Y, Z> g2) {
            this.f = f2;
            this.g = g2;
        }

        public int hashCode() {
            return this.f.hashCode() * 211 + this.g.hashCode() * 79;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Composition)) {
                return false;
            }
            Composition other = (Composition)obj;
            return Objects.equals(this.f, other.f) && Objects.equals(this.g, other.g);
        }

        @Override
        public Z apply(X x2) {
            return this.g.apply(this.f.apply(x2));
        }
    }
}

