/*
 * Decompiled with CFR 0.152.
 */
package water.webserver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import water.ExtensionManager;
import water.init.JarHash;
import water.server.ServletService;
import water.server.ServletUtils;
import water.util.FileUtils;
import water.util.Log;
import water.webserver.iface.H2OHttpConfig;
import water.webserver.iface.H2OHttpView;
import water.webserver.iface.H2OWebsocketServlet;
import water.webserver.iface.RequestAuthExtension;

public class H2OHttpViewImpl
implements H2OHttpView {
    private static volatile boolean _acceptRequests = false;
    private final H2OHttpConfig config;
    private byte[] proxyLoginFormData;

    public H2OHttpViewImpl(H2OHttpConfig config) {
        this.config = config;
    }

    public void acceptRequests() {
        _acceptRequests = true;
    }

    public String getScheme() {
        return this.config.jks == null ? "http" : "https";
    }

    @Override
    public LinkedHashMap<String, Class<? extends HttpServlet>> getServlets() {
        return ServletService.INSTANCE.getAllServlets();
    }

    @Override
    public LinkedHashMap<String, Class<? extends H2OWebsocketServlet>> getWebsockets() {
        return ServletService.INSTANCE.getAllWebsockets();
    }

    @Override
    public boolean authenticationHandler(HttpServletRequest request2, HttpServletResponse response) throws IOException {
        if (!this.config.loginType.needToCheckUserName()) {
            return false;
        }
        if (request2.getUserPrincipal() == null) {
            throw new IllegalStateException("AuthenticateHandler called with request.userPrincipal is null");
        }
        String loginName = request2.getUserPrincipal().getName();
        if (loginName.equals(this.config.user_name)) {
            return false;
        }
        Log.warn("Login name (" + loginName + ") does not match cluster owner name (" + this.config.user_name + ")");
        ServletUtils.sendResponseError(response, 401, "Login name does not match cluster owner name");
        return true;
    }

    @Override
    public boolean gateHandler(HttpServletRequest request2, HttpServletResponse response) {
        ServletUtils.startRequestLifecycle();
        while (!this.isAcceptingRequests()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        boolean isXhrRequest = false;
        if (request2 != null) {
            if (ServletUtils.isTraceRequest(request2)) {
                ServletUtils.setResponseStatus(response, 405);
                return true;
            }
            isXhrRequest = ServletUtils.isXhrRequest(request2);
        }
        ServletUtils.setCommonResponseHttpHeaders(response, isXhrRequest);
        return false;
    }

    protected boolean isAcceptingRequests() {
        return _acceptRequests;
    }

    @Override
    public H2OHttpConfig getConfig() {
        return this.config;
    }

    @Override
    public Collection<RequestAuthExtension> getAuthExtensions() {
        return ExtensionManager.getInstance().getAuthExtensions();
    }

    @Override
    public boolean loginHandler(String target, HttpServletRequest request2, HttpServletResponse response) throws IOException {
        if (!H2OHttpViewImpl.isLoginTarget(target)) {
            return false;
        }
        if (H2OHttpViewImpl.isPageRequest(request2)) {
            H2OHttpViewImpl.sendLoginForm(request2, response);
        } else {
            ServletUtils.sendResponseError(response, 401, "Access denied. Please login.");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendLoginForm(HttpServletRequest request2, HttpServletResponse response) {
        String uri = ServletUtils.getDecodedUri(request2);
        try {
            byte[] bytes;
            try (InputStream resource = JarHash.getResource2("/login.html");){
                if (resource == null) {
                    throw new IllegalStateException("Login form not found");
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                FileUtils.copyStream(resource, baos, 2048);
                bytes = baos.toByteArray();
            }
            response.setContentType("text/html");
            response.setContentLength(bytes.length);
            ServletUtils.setResponseStatus(response, 200);
            ServletOutputStream os2 = response.getOutputStream();
            FileUtils.copyStream(new ByteArrayInputStream(bytes), os2, 2048);
        }
        catch (Exception e2) {
            ServletUtils.sendErrorResponse(response, e2, uri);
        }
        finally {
            ServletUtils.logRequest("GET", request2, response);
        }
    }

    private static boolean isPageRequest(HttpServletRequest request2) {
        String accept = request2.getHeader("Accept");
        return accept != null && accept.contains("text/html");
    }

    private static boolean isLoginTarget(String target) {
        return target.equals("/login") || target.equals("/loginError");
    }

    @Override
    public boolean proxyLoginHandler(String target, HttpServletRequest request2, HttpServletResponse response) throws IOException {
        if (!H2OHttpViewImpl.isLoginTarget(target)) {
            return false;
        }
        if (H2OHttpViewImpl.isPageRequest(request2)) {
            this.proxySendLoginForm(response);
        } else {
            response.sendError(401, "Access denied. Please login.");
        }
        return true;
    }

    private static byte[] proxyLoadLoginFormResource() throws IOException {
        InputStream loginFormStream = H2OHttpView.class.getResourceAsStream("/www/login.html");
        if (loginFormStream == null) {
            throw new IllegalStateException("Login form resource is missing.");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)loginFormStream, (OutputStream)baos);
        return baos.toByteArray();
    }

    private void proxySendLoginForm(HttpServletResponse response) throws IOException {
        if (this.proxyLoginFormData == null) {
            this.proxyLoginFormData = H2OHttpViewImpl.proxyLoadLoginFormResource();
        }
        response.setContentType("text/html");
        response.setContentLength(this.proxyLoginFormData.length);
        response.setStatus(200);
        IOUtils.write((byte[])this.proxyLoginFormData, (OutputStream)response.getOutputStream());
    }
}

