/*
 * Decompiled with CFR 0.152.
 */
package water.webserver.jetty9;

import ai.h2o.org.eclipse.jetty.jaas.JAASLoginService;
import ai.h2o.org.eclipse.jetty.security.Authenticator;
import ai.h2o.org.eclipse.jetty.security.ConstraintMapping;
import ai.h2o.org.eclipse.jetty.security.ConstraintSecurityHandler;
import ai.h2o.org.eclipse.jetty.security.DefaultIdentityService;
import ai.h2o.org.eclipse.jetty.security.HashLoginService;
import ai.h2o.org.eclipse.jetty.security.LoginService;
import ai.h2o.org.eclipse.jetty.security.SpnegoLoginService;
import ai.h2o.org.eclipse.jetty.security.authentication.BasicAuthenticator;
import ai.h2o.org.eclipse.jetty.security.authentication.FormAuthenticator;
import ai.h2o.org.eclipse.jetty.security.authentication.LoginAuthenticator;
import ai.h2o.org.eclipse.jetty.security.authentication.SpnegoAuthenticator;
import ai.h2o.org.eclipse.jetty.server.AbstractConnectionFactory;
import ai.h2o.org.eclipse.jetty.server.Connector;
import ai.h2o.org.eclipse.jetty.server.Handler;
import ai.h2o.org.eclipse.jetty.server.HttpConfiguration;
import ai.h2o.org.eclipse.jetty.server.HttpConnectionFactory;
import ai.h2o.org.eclipse.jetty.server.Request;
import ai.h2o.org.eclipse.jetty.server.Server;
import ai.h2o.org.eclipse.jetty.server.ServerConnector;
import ai.h2o.org.eclipse.jetty.server.handler.AbstractHandler;
import ai.h2o.org.eclipse.jetty.server.handler.HandlerWrapper;
import ai.h2o.org.eclipse.jetty.server.session.SessionHandler;
import ai.h2o.org.eclipse.jetty.servlet.ServletContextHandler;
import ai.h2o.org.eclipse.jetty.util.component.AbstractLifeCycle;
import ai.h2o.org.eclipse.jetty.util.security.Constraint;
import ai.h2o.org.eclipse.jetty.util.ssl.SslContextFactory;
import ai.h2o.org.eclipse.jetty.util.thread.QueuedThreadPool;
import ai.h2o.org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import ai.h2o.org.eclipse.jetty.util.thread.Scheduler;
import java.io.IOException;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import water.webserver.config.ConnectionConfiguration;
import water.webserver.iface.H2OHttpConfig;
import water.webserver.iface.H2OHttpView;
import water.webserver.iface.LoginType;
import water.webserver.jetty9.H2OHttpConfiguration;
import water.webserver.jetty9.Jetty9DelegatingAuthenticator;

class Jetty9Helper {
    private final H2OHttpConfig config;
    private final H2OHttpView h2oHttpView;

    Jetty9Helper(H2OHttpView h2oHttpView) {
        this.h2oHttpView = h2oHttpView;
        this.config = h2oHttpView.getConfig();
    }

    Server createJettyServer(String ip, int port) {
        ServerConnector connector;
        Server jettyServer;
        System.setProperty("ai.h2o.org.eclipse.jetty.server.Request.maxFormContentSize", Integer.toString(Integer.MAX_VALUE));
        if (this.config.ensure_daemon_threads) {
            QueuedThreadPool pool = new QueuedThreadPool();
            pool.setDaemon(true);
            jettyServer = new Server(pool);
            Scheduler s2 = jettyServer.getBean(Scheduler.class);
            jettyServer.updateBean(s2, new ScheduledExecutorScheduler(null, true));
        } else {
            jettyServer = new Server();
        }
        boolean isSecured = this.config.jks != null;
        HttpConfiguration httpConfiguration = Jetty9Helper.makeHttpConfiguration(new ConnectionConfiguration(isSecured));
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(httpConfiguration);
        if (isSecured) {
            SslContextFactory sslContextFactory = new SslContextFactory(this.config.jks);
            sslContextFactory.setKeyStorePassword(this.config.jks_pass);
            if (this.config.jks_alias != null) {
                sslContextFactory.setCertAlias(this.config.jks_alias);
            }
            connector = new ServerConnector(jettyServer, AbstractConnectionFactory.getFactories(sslContextFactory, httpConnectionFactory));
        } else {
            connector = new ServerConnector(jettyServer, httpConnectionFactory);
        }
        if (ip != null) {
            connector.setHost(ip);
        }
        connector.setPort(port);
        jettyServer.setConnectors(new Connector[]{connector});
        return jettyServer;
    }

    static HttpConfiguration makeHttpConfiguration(ConnectionConfiguration cfg) {
        H2OHttpConfiguration httpConfiguration = new H2OHttpConfiguration();
        httpConfiguration.setSendServerVersion(false);
        httpConfiguration.setRequestHeaderSize(cfg.getRequestHeaderSize());
        httpConfiguration.setResponseHeaderSize(cfg.getResponseHeaderSize());
        httpConfiguration.setOutputBufferSize(cfg.getOutputBufferSize(httpConfiguration.getOutputBufferSize()));
        httpConfiguration.setRelativeRedirectAllowed(cfg.isRelativeRedirectAllowed());
        httpConfiguration.setIdleTimeout(cfg.getIdleTimeout());
        return httpConfiguration;
    }

    HandlerWrapper authWrapper(Server jettyServer) {
        Authenticator authenticator;
        LoginAuthenticator primaryAuthenticator;
        AbstractLifeCycle loginService;
        if (this.config.loginType == LoginType.NONE) {
            return jettyServer;
        }
        switch (this.config.loginType) {
            case HASH: {
                loginService = new HashLoginService("H2O", this.config.login_conf);
                primaryAuthenticator = new BasicAuthenticator();
                break;
            }
            case LDAP: 
            case KERBEROS: 
            case PAM: {
                loginService = new JAASLoginService(this.config.loginType.jaasRealm);
                primaryAuthenticator = new BasicAuthenticator();
                break;
            }
            case SPNEGO: {
                System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
                loginService = new SpnegoLoginService(this.config.loginType.jaasRealm, this.config.spnego_properties);
                primaryAuthenticator = new SpnegoAuthenticator();
                break;
            }
            default: {
                throw new UnsupportedOperationException((Object)((Object)this.config.loginType) + "");
            }
        }
        DefaultIdentityService identityService = new DefaultIdentityService();
        loginService.setIdentityService(identityService);
        jettyServer.addBean(loginService);
        ConstraintSecurityHandler security = new ConstraintSecurityHandler();
        Constraint constraint = new Constraint();
        constraint.setName("auth");
        constraint.setAuthenticate(true);
        constraint.setRoles(new String[]{"**"});
        ConstraintMapping mapping = new ConstraintMapping();
        mapping.setPathSpec("/*");
        mapping.setConstraint(constraint);
        security.setConstraintMappings(Collections.singletonList(mapping));
        if (this.config.form_auth) {
            FormAuthenticator formAuthenticator = new FormAuthenticator("/login", "/loginError", false);
            authenticator = new Jetty9DelegatingAuthenticator(primaryAuthenticator, formAuthenticator);
        } else {
            authenticator = primaryAuthenticator;
        }
        security.setLoginService((LoginService)((Object)loginService));
        security.setAuthenticator(authenticator);
        SessionHandler sessionHandler = new SessionHandler();
        if (this.config.session_timeout > 0) {
            sessionHandler.setMaxInactiveInterval(this.config.session_timeout * 60);
        }
        sessionHandler.setHandler(security);
        jettyServer.setSessionIdManager(sessionHandler.getSessionIdManager());
        jettyServer.setHandler(sessionHandler);
        return security;
    }

    ServletContextHandler createServletContextHandler() {
        ServletContextHandler context = new ServletContextHandler(0);
        if (null != this.config.context_path && !this.config.context_path.isEmpty()) {
            context.setContextPath(this.config.context_path);
        } else {
            context.setContextPath("/");
        }
        return context;
    }

    Handler authenticationHandler() {
        return new AuthenticationHandler();
    }

    private class AuthenticationHandler
    extends AbstractHandler {
        private AuthenticationHandler() {
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request2, HttpServletResponse response) throws IOException {
            boolean handled = Jetty9Helper.this.h2oHttpView.authenticationHandler(request2, response);
            if (handled) {
                baseRequest.setHandled(true);
            }
        }
    }
}

