/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.backend.external;

import ai.h2o.sparkling.H2OConf;
import ai.h2o.sparkling.backend.external.K8sHeadlessService;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.CreateOrReplaceable;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Nameable;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;

public abstract class K8sHeadlessService$class {
    public static String getH2OHeadlessServiceURL(K8sHeadlessService $this, H2OConf conf) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ".svc.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{conf.externalK8sH2OServiceName(), conf.externalK8sNamespace(), conf.externalK8sDomain()}));
    }

    public static void installH2OHeadlessService(K8sHeadlessService $this, KubernetesClient client, H2OConf conf) {
        Service service = (Service)((Gettable)client.services().load(K8sHeadlessService$class.spec($this, conf))).get();
        ((CreateOrReplaceable)client.services().inNamespace(conf.externalK8sNamespace())).createOrReplace((Object[])new Service[]{service});
    }

    public static void deleteH2OHeadlessService(K8sHeadlessService $this, KubernetesClient client, H2OConf conf) {
        ((Deletable)((Nameable)client.services().inNamespace(conf.externalK8sNamespace())).withName(conf.externalK8sH2OServiceName())).delete();
    }

    private static InputStream spec(K8sHeadlessService $this, H2OConf conf) {
        String spec = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      |apiVersion: v1\n      |kind: Service\n      |metadata:\n      |  name: ", "\n      |  namespace: ", "\n      |spec:\n      |  type: ClusterIP\n      |  clusterIP: None\n      |  selector:\n      |    ", "\n      |  ports:\n      |  - protocol: TCP\n      |    port: 54321"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{conf.externalK8sH2OServiceName(), conf.externalK8sNamespace(), $this.convertLabel(conf.externalK8sH2OLabel())})))).stripMargin();
        return new ByteArrayInputStream(spec.getBytes());
    }

    public static void $init$(K8sHeadlessService $this) {
    }
}

