/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.ml.params;

import ai.h2o.sparkling.H2OFrame;
import ai.h2o.sparkling.ml.params.EnumParamValidator$;
import ai.h2o.sparkling.ml.params.H2OWord2VecParams;
import hex.word2vec.Word2Vec;
import hex.word2vec.Word2VecModel;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamPair;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.package$;
import scala.runtime.BoxesRunTime;

public abstract class H2OWord2VecParams$class {
    public static ClassTag paramTag(H2OWord2VecParams $this) {
        return package$.MODULE$.classTag(ClassTag$.MODULE$.apply(Word2VecModel.Word2VecParameters.class));
    }

    public static int getVecSize(H2OWord2VecParams $this) {
        return BoxesRunTime.unboxToInt((Object)$this.$((Param)$this.vecSize()));
    }

    public static int getWindowSize(H2OWord2VecParams $this) {
        return BoxesRunTime.unboxToInt((Object)$this.$((Param)$this.windowSize()));
    }

    public static float getSentSampleRate(H2OWord2VecParams $this) {
        return BoxesRunTime.unboxToFloat((Object)$this.$((Param)$this.sentSampleRate()));
    }

    public static String getNormModel(H2OWord2VecParams $this) {
        return (String)$this.$($this.normModel());
    }

    public static int getEpochs(H2OWord2VecParams $this) {
        return BoxesRunTime.unboxToInt((Object)$this.$((Param)$this.epochs()));
    }

    public static int getMinWordFreq(H2OWord2VecParams $this) {
        return BoxesRunTime.unboxToInt((Object)$this.$((Param)$this.minWordFreq()));
    }

    public static float getInitLearningRate(H2OWord2VecParams $this) {
        return BoxesRunTime.unboxToFloat((Object)$this.$((Param)$this.initLearningRate()));
    }

    public static String getWordModel(H2OWord2VecParams $this) {
        return (String)$this.$($this.wordModel());
    }

    public static String getModelId(H2OWord2VecParams $this) {
        return (String)$this.$($this.modelId());
    }

    public static double getMaxRuntimeSecs(H2OWord2VecParams $this) {
        return BoxesRunTime.unboxToDouble((Object)$this.$((Param)$this.maxRuntimeSecs()));
    }

    public static String getExportCheckpointsDir(H2OWord2VecParams $this) {
        return (String)$this.$($this.exportCheckpointsDir());
    }

    public static H2OWord2VecParams setVecSize(H2OWord2VecParams $this, int value) {
        return (H2OWord2VecParams)$this.set((Param)$this.vecSize(), BoxesRunTime.boxToInteger((int)value));
    }

    public static H2OWord2VecParams setWindowSize(H2OWord2VecParams $this, int value) {
        return (H2OWord2VecParams)$this.set((Param)$this.windowSize(), BoxesRunTime.boxToInteger((int)value));
    }

    public static H2OWord2VecParams setSentSampleRate(H2OWord2VecParams $this, float value) {
        return (H2OWord2VecParams)$this.set((Param)$this.sentSampleRate(), BoxesRunTime.boxToFloat((float)value));
    }

    public static H2OWord2VecParams setNormModel(H2OWord2VecParams $this, String value) {
        String validated = EnumParamValidator$.MODULE$.getValidatedEnumValue(value, ClassTag$.MODULE$.apply(Word2Vec.NormModel.class));
        return (H2OWord2VecParams)$this.set($this.normModel(), validated);
    }

    public static H2OWord2VecParams setEpochs(H2OWord2VecParams $this, int value) {
        return (H2OWord2VecParams)$this.set((Param)$this.epochs(), BoxesRunTime.boxToInteger((int)value));
    }

    public static H2OWord2VecParams setMinWordFreq(H2OWord2VecParams $this, int value) {
        return (H2OWord2VecParams)$this.set((Param)$this.minWordFreq(), BoxesRunTime.boxToInteger((int)value));
    }

    public static H2OWord2VecParams setInitLearningRate(H2OWord2VecParams $this, float value) {
        return (H2OWord2VecParams)$this.set((Param)$this.initLearningRate(), BoxesRunTime.boxToFloat((float)value));
    }

    public static H2OWord2VecParams setWordModel(H2OWord2VecParams $this, String value) {
        String validated = EnumParamValidator$.MODULE$.getValidatedEnumValue(value, ClassTag$.MODULE$.apply(Word2Vec.WordModel.class));
        return (H2OWord2VecParams)$this.set($this.wordModel(), validated);
    }

    public static H2OWord2VecParams setModelId(H2OWord2VecParams $this, String value) {
        return (H2OWord2VecParams)$this.set($this.modelId(), value);
    }

    public static H2OWord2VecParams setMaxRuntimeSecs(H2OWord2VecParams $this, double value) {
        return (H2OWord2VecParams)$this.set((Param)$this.maxRuntimeSecs(), BoxesRunTime.boxToDouble((double)value));
    }

    public static H2OWord2VecParams setExportCheckpointsDir(H2OWord2VecParams $this, String value) {
        return (H2OWord2VecParams)$this.set($this.exportCheckpointsDir(), value);
    }

    public static Map getH2OAlgorithmParams(H2OWord2VecParams $this, H2OFrame trainingFrame) {
        return $this.ai$h2o$sparkling$ml$params$H2OWord2VecParams$$super$getH2OAlgorithmParams(trainingFrame).$plus$plus($this.getH2OWord2VecParams(trainingFrame));
    }

    public static Map getH2OWord2VecParams(H2OWord2VecParams $this, H2OFrame trainingFrame) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"vec_size"), (Object)BoxesRunTime.boxToInteger((int)$this.getVecSize())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"window_size"), (Object)BoxesRunTime.boxToInteger((int)$this.getWindowSize())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sent_sample_rate"), (Object)BoxesRunTime.boxToFloat((float)$this.getSentSampleRate())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"norm_model"), (Object)$this.getNormModel()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"epochs"), (Object)BoxesRunTime.boxToInteger((int)$this.getEpochs())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"min_word_freq"), (Object)BoxesRunTime.boxToInteger((int)$this.getMinWordFreq())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"init_learning_rate"), (Object)BoxesRunTime.boxToFloat((float)$this.getInitLearningRate())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"word_model"), (Object)$this.getWordModel()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"model_id"), (Object)$this.getModelId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max_runtime_secs"), (Object)BoxesRunTime.boxToDouble((double)$this.getMaxRuntimeSecs())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"export_checkpoints_dir"), (Object)$this.getExportCheckpointsDir())}));
    }

    public static Map getSWtoH2OParamNameMap(H2OWord2VecParams $this) {
        return $this.ai$h2o$sparkling$ml$params$H2OWord2VecParams$$super$getSWtoH2OParamNameMap().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"vecSize"), (Object)"vec_size"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"windowSize"), (Object)"window_size"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sentSampleRate"), (Object)"sent_sample_rate"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"normModel"), (Object)"norm_model"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"epochs"), (Object)"epochs"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"minWordFreq"), (Object)"min_word_freq"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"initLearningRate"), (Object)"init_learning_rate"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"wordModel"), (Object)"word_model"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"modelId"), (Object)"model_id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxRuntimeSecs"), (Object)"max_runtime_secs"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exportCheckpointsDir"), (Object)"export_checkpoints_dir")})));
    }

    public static void $init$(H2OWord2VecParams $this) {
        $this.ai$h2o$sparkling$ml$params$H2OWord2VecParams$_setter_$vecSize_$eq($this.intParam("vecSize", "Set size of word vectors."));
        $this.ai$h2o$sparkling$ml$params$H2OWord2VecParams$_setter_$windowSize_$eq($this.intParam("windowSize", "Set max skip length between words."));
        $this.ai$h2o$sparkling$ml$params$H2OWord2VecParams$_setter_$sentSampleRate_$eq($this.floatParam("sentSampleRate", "Set threshold for occurrence of words. Those that appear with higher frequency in the training data\n\t\twill be randomly down-sampled; useful range is (0, 1e-5)."));
        $this.ai$h2o$sparkling$ml$params$H2OWord2VecParams$_setter_$normModel_$eq($this.stringParam("normModel", "Use Hierarchical Softmax. Possible values are ``\"HSM\"``."));
        $this.ai$h2o$sparkling$ml$params$H2OWord2VecParams$_setter_$epochs_$eq($this.intParam("epochs", "Number of training iterations to run."));
        $this.ai$h2o$sparkling$ml$params$H2OWord2VecParams$_setter_$minWordFreq_$eq($this.intParam("minWordFreq", "This will discard words that appear less than <int> times."));
        $this.ai$h2o$sparkling$ml$params$H2OWord2VecParams$_setter_$initLearningRate_$eq($this.floatParam("initLearningRate", "Set the starting learning rate."));
        $this.ai$h2o$sparkling$ml$params$H2OWord2VecParams$_setter_$wordModel_$eq($this.stringParam("wordModel", "The word model to use (SkipGram or CBOW). Possible values are ``\"SkipGram\"``, ``\"CBOW\"``."));
        $this.ai$h2o$sparkling$ml$params$H2OWord2VecParams$_setter_$modelId_$eq($this.nullableStringParam("modelId", "Destination id for this model; auto-generated if not specified."));
        $this.ai$h2o$sparkling$ml$params$H2OWord2VecParams$_setter_$maxRuntimeSecs_$eq($this.doubleParam("maxRuntimeSecs", "Maximum allowed runtime in seconds for model training. Use 0 to disable."));
        $this.ai$h2o$sparkling$ml$params$H2OWord2VecParams$_setter_$exportCheckpointsDir_$eq($this.nullableStringParam("exportCheckpointsDir", "Automatically export generated models to this directory."));
        $this.setDefault((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{$this.vecSize().$minus$greater((Object)BoxesRunTime.boxToInteger((int)100)), $this.windowSize().$minus$greater((Object)BoxesRunTime.boxToInteger((int)5)), $this.sentSampleRate().$minus$greater((Object)BoxesRunTime.boxToFloat((float)0.001f)), $this.normModel().$minus$greater((Object)Word2Vec.NormModel.HSM.name()), $this.epochs().$minus$greater((Object)BoxesRunTime.boxToInteger((int)5)), $this.minWordFreq().$minus$greater((Object)BoxesRunTime.boxToInteger((int)5)), $this.initLearningRate().$minus$greater((Object)BoxesRunTime.boxToFloat((float)0.025f)), $this.wordModel().$minus$greater((Object)Word2Vec.WordModel.SkipGram.name()), $this.modelId().$minus$greater(null), $this.maxRuntimeSecs().$minus$greater((Object)BoxesRunTime.boxToDouble((double)0.0)), $this.exportCheckpointsDir().$minus$greater(null)}));
    }
}

