/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.backend.utils;

import ai.h2o.sparkling.H2OConf;
import ai.h2o.sparkling.H2OContext;
import ai.h2o.sparkling.H2OFrame;
import ai.h2o.sparkling.H2OFrame$;
import ai.h2o.sparkling.backend.BuildInfo$;
import ai.h2o.sparkling.backend.H2OJob$;
import ai.h2o.sparkling.backend.NodeDesc;
import ai.h2o.sparkling.backend.SharedBackendConf$;
import ai.h2o.sparkling.backend.exceptions.H2OClusterNotReachableException;
import ai.h2o.sparkling.backend.exceptions.RestApiCommunicationException;
import ai.h2o.sparkling.backend.exceptions.RestApiException;
import ai.h2o.sparkling.backend.external.ExternalBackendConf$;
import ai.h2o.sparkling.backend.external.K8sExternalBackendClient$;
import ai.h2o.sparkling.backend.internal.InternalBackendConf$;
import ai.h2o.sparkling.backend.utils.H2OContextExtensions;
import ai.h2o.sparkling.backend.utils.H2OContextExtensions$;
import ai.h2o.sparkling.backend.utils.RestApiUtils$;
import ai.h2o.sparkling.extensions.rest.api.schema.VerifyVersionV3;
import ai.h2o.sparkling.extensions.rest.api.schema.VerifyWebOpenV3;
import java.awt.Desktop;
import java.io.File;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.spark.SparkContext;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Mirrors;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import water.api.schemas3.CloudLockV3;
import water.api.schemas3.JobV3;

public abstract class H2OContextExtensions$class {
    public static String downloadH2OLogs(H2OContext $this, String destinationDir, String logContainer) {
        String string;
        block4: {
            File file;
            block3: {
                String logEndpoint;
                URI endpoint;
                block2: {
                    H2OContextExtensions$class.verifyLogContainer($this, logContainer);
                    endpoint = RestApiUtils$.MODULE$.getClusterEndpoint($this.getConf());
                    file = new File(destinationDir, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{H2OContextExtensions$class.logFileName($this), logContainer.toLowerCase()})));
                    logEndpoint = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/3/Logs/download/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{logContainer}));
                    string = logContainer;
                    if (!"LOG".equals(string)) break block2;
                    $this.downloadStringURLContent(endpoint, logEndpoint, $this.getConf(), file);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!"ZIP".equals(string)) break block4;
                $this.downloadBinaryURLContent(endpoint, logEndpoint, $this.getConf(), file);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return file.getAbsolutePath();
        }
        throw new MatchError((Object)string);
    }

    public static H2OFrame importHiveTable(H2OContext $this, String database, String table, String[][] partitions, boolean allowMultiFormat) {
        URI endpoint = RestApiUtils$.MODULE$.getClusterEndpoint($this.getConf());
        Map params = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"database"), (Object)database), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"table"), (Object)table), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitions"), (Object)partitions), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"allow_multi_format"), (Object)BoxesRunTime.boxToBoolean((boolean)allowMultiFormat))}));
        try {
            JobV3 job = (JobV3)RestApiUtils$.MODULE$.update(endpoint, "/3/ImportHiveTable", $this.getConf(), (Map<String, Object>)params, RestApiUtils$.MODULE$.update$default$5(), RestApiUtils$.MODULE$.update$default$6(), ClassTag$.MODULE$.apply(JobV3.class));
            H2OJob$.MODULE$.apply(job.key.name).waitForFinishAndPrintProgress();
            return H2OFrame$.MODULE$.apply(job.dest.name);
        }
        catch (Throwable throwable) {
            RestApiCommunicationException restApiCommunicationException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof RestApiCommunicationException && (restApiCommunicationException = (RestApiCommunicationException)throwable2).getMessage().contains("table not found")) {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table '", "' not found in the Hive database '", "'!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table, database})));
            }
            throw throwable;
        }
    }

    public static String importHiveTable$default$1(H2OContext $this) {
        return "default";
    }

    public static String[][] importHiveTable$default$3(H2OContext $this) {
        return null;
    }

    public static boolean importHiveTable$default$4(H2OContext $this) {
        return false;
    }

    public static H2OFrame withConversionDebugPrints(H2OContext $this, SparkContext sc, String conversionName, Function0 block) {
        H2OFrame h2OFrame;
        String propName = "spark.h2o.measurements.timing";
        Option performancePrintConf = sc.getConf().getOption(propName).orElse((Function0)new Serializable($this, propName){
            public static final long serialVersionUID = 0L;
            private final String propName$1;

            public final Option<String> apply() {
                return scala.sys.package$.MODULE$.props().get(this.propName$1);
            }
            {
                this.propName$1 = propName$1;
            }
        });
        if (performancePrintConf.nonEmpty() && new StringOps(Predef$.MODULE$.augmentString((String)performancePrintConf.get())).toBoolean()) {
            long t0 = System.nanoTime();
            H2OFrame result = (H2OFrame)block.apply();
            long t1 = System.nanoTime();
            $this.logInfo((Function0<String>)new Serializable($this, t0, result, t1, conversionName){
                public static final long serialVersionUID = 0L;
                private final long t0$1;
                private final H2OFrame result$1;
                private final long t1$1;
                private final String conversionName$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Elapsed time of the ", " conversion into H2OFrame ", ": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.conversionName$1, this.result$1.frameId()}))).append((Object)BoxesRunTime.boxToLong((long)((this.t1$1 - this.t0$1) / 1000L))).append((Object)" millis").toString();
                }
                {
                    this.t0$1 = t0$1;
                    this.result$1 = result$1;
                    this.t1$1 = t1$1;
                    this.conversionName$1 = conversionName$1;
                }
            });
            h2OFrame = result;
        } else {
            h2OFrame = (H2OFrame)block.apply();
        }
        return h2OFrame;
    }

    public static void openURI(H2OContext $this, String uri) {
        if (Desktop.isDesktopSupported()) {
            Desktop.getDesktop().browse(new URI(uri));
        } else {
            $this.logWarning((Function0<String>)new Serializable($this, uri){
                public static final long serialVersionUID = 0L;
                private final String uri$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Desktop support is missing! Cannot open browser for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.uri$1}));
                }
                {
                    this.uri$1 = uri$1;
                }
            });
        }
    }

    private static String logFileName(H2OContext $this) {
        String pattern = "yyyyMMdd_hhmmss";
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        String now = formatter.format(new Date());
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"h2ologs_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{now}));
    }

    private static void verifyLogContainer(H2OContext $this, String logContainer) {
        if (((SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ZIP", "LOG"}))).contains((Object)logContainer)) {
            return;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Supported LOG container is either LOG or ZIP, specified was: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{logContainer})));
    }

    private static boolean tryToLockCloud(H2OContext $this, H2OConf conf, boolean catchException) {
        Throwable throwable2;
        block2: {
            boolean bl;
            String h2oCluster = new StringBuilder().append((Object)((String)conf.h2oCluster().get())).append(conf.contextPath().getOrElse((Function0)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            })).toString();
            String h2oClusterName = (String)conf.cloudName().get();
            try {
                $this.logInfo((Function0<String>)new Serializable($this, h2oCluster, h2oClusterName){
                    public static final long serialVersionUID = 0L;
                    private final String h2oCluster$1;
                    private final String h2oClusterName$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Trying to lock H2O cluster ", " - ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.h2oCluster$1, this.h2oClusterName$1}));
                    }
                    {
                        this.h2oCluster$1 = h2oCluster$1;
                        this.h2oClusterName$1 = h2oClusterName$1;
                    }
                });
                H2OContextExtensions$class.lockCloud($this, conf);
                bl = true;
            }
            catch (Throwable throwable2) {
                boolean bl2;
                Throwable throwable3 = throwable2;
                if (!(throwable3 instanceof RestApiException)) break block2;
                RestApiException restApiException = (RestApiException)throwable3;
                if (!catchException) break block2;
                $this.logWarning((Function0<String>)new Serializable($this, h2oCluster, h2oClusterName){
                    public static final long serialVersionUID = 0L;
                    private final String h2oCluster$1;
                    private final String h2oClusterName$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Locking of the H2O cluster ", " - ", " failed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.h2oCluster$1, this.h2oClusterName$1}));
                    }
                    {
                        this.h2oCluster$1 = h2oCluster$1;
                        this.h2oClusterName$1 = h2oClusterName$1;
                    }
                }, restApiException);
                bl = bl2 = false;
            }
            return bl;
        }
        throw throwable2;
    }

    public static NodeDesc[] getAndVerifyWorkerNodes(H2OContext $this, H2OConf conf) {
        try {
            int maximumNumberOfAttempts = 6;
            int attemptId = 0;
            while (attemptId < maximumNumberOfAttempts) {
                boolean catchException = attemptId < maximumNumberOfAttempts - 1;
                boolean locked = H2OContextExtensions$class.tryToLockCloud($this, conf, catchException);
                if (locked) {
                    attemptId = maximumNumberOfAttempts;
                    continue;
                }
                Thread.sleep(10000L);
                ++attemptId;
            }
            H2OContextExtensions$class.verifyWebOpen($this, conf);
            if (!conf.isBackendVersionCheckDisabled()) {
                H2OContextExtensions$class.verifyVersion($this, conf);
            }
            return RestApiUtils$.MODULE$.getNodes(conf);
        }
        catch (RestApiException restApiException) {
            if (conf.isAutoClusterStartUsed()) {
                H2OContextExtensions$class.stopExternalH2OCluster($this, conf);
            }
            String h2oCluster = new StringBuilder().append((Object)((String)conf.h2oCluster().get())).append(conf.contextPath().getOrElse((Function0)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            })).toString();
            String h2oClusterName = (String)conf.cloudName().get();
            throw new H2OClusterNotReachableException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"H2O cluster ", " - ", " is not reachable.\n             |H2OContext has not been created."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{h2oCluster, h2oClusterName})))).stripMargin(), restApiException);
        }
    }

    public static Map collectPropertiesDoc(H2OContext $this) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(H2OContextExtensions.class.getClassLoader());
        public final class Ai_h2o_sparkling_backend_utils_H2OContextExtensions$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("ai.h2o.sparkling.backend").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("ai.h2o.sparkling.backend.SharedBackendConf"));
            }

            public Ai_h2o_sparkling_backend_utils_H2OContextExtensions$$typecreator1$1(H2OContext $outer) {
            }
        }
        Map sharedConfOptions = H2OContextExtensions$class.collectPropertiesDoc($this, SharedBackendConf$.MODULE$, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Ai_h2o_sparkling_backend_utils_H2OContextExtensions$$typecreator1$1($this)));
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(H2OContextExtensions.class.getClassLoader());
        public final class Ai_h2o_sparkling_backend_utils_H2OContextExtensions$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("ai.h2o.sparkling.backend.internal").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("ai.h2o.sparkling.backend.internal.InternalBackendConf"));
            }

            public Ai_h2o_sparkling_backend_utils_H2OContextExtensions$$typecreator2$1(H2OContext $outer) {
            }
        }
        Map internalConfOptions = H2OContextExtensions$class.collectPropertiesDoc($this, InternalBackendConf$.MODULE$, ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Ai_h2o_sparkling_backend_utils_H2OContextExtensions$$typecreator2$1($this)));
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(H2OContextExtensions.class.getClassLoader());
        public final class Ai_h2o_sparkling_backend_utils_H2OContextExtensions$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("ai.h2o.sparkling.backend.external").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("ai.h2o.sparkling.backend.external.ExternalBackendConf"));
            }

            public Ai_h2o_sparkling_backend_utils_H2OContextExtensions$$typecreator3$1(H2OContext $outer) {
            }
        }
        Map externalConfOptions = H2OContextExtensions$class.collectPropertiesDoc($this, ExternalBackendConf$.MODULE$, ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Ai_h2o_sparkling_backend_utils_H2OContextExtensions$$typecreator3$1($this)));
        return sharedConfOptions.$plus$plus((GenTraversableOnce)internalConfOptions).$plus$plus((GenTraversableOnce)externalConfOptions);
    }

    private static Map collectPropertiesDoc(H2OContext $this, Object t2, TypeTags.TypeTag tag) {
        JavaUniverse ru = package$.MODULE$.universe();
        JavaUniverse.JavaMirror rm = ru.runtimeMirror($this.getClass().getClassLoader());
        Mirrors.InstanceMirror instanceMirror = rm.reflect(t2, ClassTag$.MODULE$.Object());
        Types.TypeApi typ = ((TypeTags)ru).typeOf(tag.in((Mirror)ru.runtimeMirror(H2OContextExtensions.class.getClassLoader())));
        Iterable members = (Iterable)((TraversableLike)typ.members().filter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Symbols.SymbolApi x$2) {
                return x$2.isPublic();
            }
        })).filter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Symbols.SymbolApi x$3) {
                return x$3.name().toString().startsWith("PROP_");
            }
        });
        Iterable reflectedMembers = (Iterable)((TraversableLike)members.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Symbols.TermSymbolApi apply(Symbols.SymbolApi x$4) {
                return x$4.asTerm();
            }
        }, Iterable$.MODULE$.canBuildFrom())).map((Function1)new Serializable($this, instanceMirror){
            public static final long serialVersionUID = 0L;
            private final Mirrors.InstanceMirror instanceMirror$1;

            public final Mirrors.FieldMirror apply(Symbols.TermSymbolApi field) {
                return this.instanceMirror$1.reflectField(field);
            }
            {
                this.instanceMirror$1 = instanceMirror$1;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        return ((TraversableOnce)reflectedMembers.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(Mirrors.FieldMirror member) {
                Tuple4 optionTuple = (Tuple4)member.get();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(optionTuple._1()), optionTuple._4());
            }
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private static void stopExternalH2OCluster(H2OContext $this, H2OConf conf) {
        block4: {
            block3: {
                String string;
                block2: {
                    string = conf.externalAutoStartBackend();
                    String string2 = ExternalBackendConf$.MODULE$.YARN_BACKEND();
                    String string3 = string;
                    if (string2 != null ? !string2.equals(string3) : string3 != null) break block2;
                    Option<String> yarnAppId = conf.getOption((String)ExternalBackendConf$.MODULE$.PROP_EXTERNAL_CLUSTER_YARN_APP_ID()._1());
                    $this.launchShellCommand((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"yarn", "application", "-kill", (String)yarnAppId.get()}))));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                String string4 = ExternalBackendConf$.MODULE$.KUBERNETES_BACKEND();
                String string5 = string;
                if (string4 != null ? !string4.equals(string5) : string5 != null) break block4;
                K8sExternalBackendClient$.MODULE$.stopExternalH2OOnKubernetes(conf);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new RuntimeException("Invalid auto cluster start backend!");
    }

    private static void verifyWebOpen(H2OContext $this, H2OConf conf) {
        URI endpoint = RestApiUtils$.MODULE$.getClusterEndpoint(conf);
        VerifyWebOpenV3 verifyWebOpenV3 = (VerifyWebOpenV3)RestApiUtils$.MODULE$.query(endpoint, "/3/verifyWebOpen", conf, RestApiUtils$.MODULE$.query$default$4(), RestApiUtils$.MODULE$.query$default$5(), RestApiUtils$.MODULE$.query$default$6(), ClassTag$.MODULE$.apply(VerifyWebOpenV3.class));
        String[] nodesWithoutWeb = verifyWebOpenV3.nodes_web_disabled;
        if (Predef$.MODULE$.refArrayOps((Object[])nodesWithoutWeb).nonEmpty()) {
            throw new H2OClusterNotReachableException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n    The following worker nodes are not reachable, but belong to the cluster:\n    ", " - ", ":\n    ----------------------------------------------\n    ", "\n\n    The common reason for this error are disabled web interfaces on the H2O worker nodes."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{conf.h2oCluster().get(), conf.cloudName().get(), Predef$.MODULE$.refArrayOps((Object[])nodesWithoutWeb).mkString("\n    ")})))).stripMargin());
        }
    }

    private static void verifyVersion(H2OContext $this, H2OConf conf) {
        String referencedVersion = BuildInfo$.MODULE$.H2OVersion();
        if (!referencedVersion.endsWith("-SNAPSHOT")) {
            URI endpoint = RestApiUtils$.MODULE$.getClusterEndpoint(conf);
            Map params = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"referenced_version"), (Object)referencedVersion)}));
            VerifyVersionV3 verifyVersionV3 = (VerifyVersionV3)RestApiUtils$.MODULE$.query(endpoint, "/3/verifyVersion", conf, (Map<String, Object>)params, RestApiUtils$.MODULE$.query$default$5(), RestApiUtils$.MODULE$.query$default$6(), ClassTag$.MODULE$.apply(VerifyVersionV3.class));
            VerifyVersionV3.NodeWithVersionV3[] nodesWrongVersion = verifyVersionV3.nodes_wrong_version;
            if (Predef$.MODULE$.refArrayOps((Object[])nodesWrongVersion).nonEmpty()) {
                if (conf.runsInExternalClusterMode() && conf.isAutoClusterStartUsed()) {
                    H2OContextExtensions$class.stopExternalH2OCluster($this, conf);
                }
                throw new RuntimeException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n    Sparkling Water is using version of H2O ", ", but the following nodes have different version:\n    ----------------------------------------------\n    ", "\n\n    Please make sure to use the corresponding assembly H2O JAR."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{referencedVersion, Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])nodesWrongVersion).map((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(VerifyVersionV3.NodeWithVersionV3 nodeWithVersion) {
                        return new StringBuilder().append((Object)nodeWithVersion.ip_port).append((Object)" - ").append((Object)nodeWithVersion.version).toString();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("\n    ")})))).stripMargin());
            }
        }
    }

    private static void lockCloud(H2OContext $this, H2OConf conf) {
        URI endpoint = RestApiUtils$.MODULE$.getClusterEndpoint(conf);
        RestApiUtils$.MODULE$.update(endpoint, "/3/CloudLock", conf, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"reason"), (Object)"Locked from Sparkling Water.")}))), RestApiUtils$.MODULE$.update$default$5(), RestApiUtils$.MODULE$.update$default$6(), ClassTag$.MODULE$.apply(CloudLockV3.class));
    }

    public static void $init$(H2OContext $this) {
    }
}

