/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.backend.utils;

import ai.h2o.org.apache.http.client.utils.URIBuilder;
import ai.h2o.sparkling.H2OConf;
import ai.h2o.sparkling.backend.NodeDesc;
import ai.h2o.sparkling.backend.utils.RestApiUtils;
import ai.h2o.sparkling.extensions.rest.api.schema.LogLevelV3;
import java.net.URI;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import water.api.schemas3.CloudV3;
import water.api.schemas3.PingV3;
import water.api.schemas3.RapidsStringV3;
import water.api.schemas3.ShutdownV3;

public abstract class RestApiUtils$class {
    public static PingV3 getPingInfo(RestApiUtils $this, H2OConf conf) {
        URI endpoint;
        URI x$1 = endpoint = $this.getClusterEndpoint(conf);
        String x$2 = "/3/Ping";
        H2OConf x$3 = conf;
        Enumeration.Value x$4 = $this.LoggingLevel().Debug();
        Map<String, Object> x$5 = $this.query$default$4();
        Seq<Tuple2<Class<?>, String>> x$6 = $this.query$default$5();
        return (PingV3)$this.query(x$1, x$2, x$3, x$5, x$6, x$4, ClassTag$.MODULE$.apply(PingV3.class));
    }

    public static void shutdownCluster(RestApiUtils $this, H2OConf conf) {
        URI endpoint = $this.getClusterEndpoint(conf);
        $this.update(endpoint, "/3/Shutdown", conf, $this.update$default$4(), $this.update$default$5(), $this.update$default$6(), ClassTag$.MODULE$.apply(ShutdownV3.class));
    }

    public static URI resolveNodeEndpoint(RestApiUtils $this, NodeDesc node, H2OConf conf) {
        return new URI(conf.getScheme(), null, node.hostname(), node.port(), (String)conf.contextPath().orNull(Predef$.MODULE$.$conforms()), null, null);
    }

    public static CloudV3 getClusterInfo(RestApiUtils $this, H2OConf conf) {
        URI endpoint = $this.getClusterEndpoint(conf);
        return (CloudV3)$this.query(endpoint, "/3/Cloud", conf, $this.query$default$4(), $this.query$default$5(), $this.query$default$6(), ClassTag$.MODULE$.apply(CloudV3.class));
    }

    public static NodeDesc[] getNodes(RestApiUtils $this, H2OConf conf) {
        CloudV3 cloudV3 = $this.getClusterInfo(conf);
        return $this.getNodes(cloudV3);
    }

    public static URI getClusterEndpoint(RestApiUtils $this, H2OConf conf) {
        URIBuilder uriBuilder = new URIBuilder(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "://", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{conf.getScheme(), conf.h2oCluster().get()})));
        uriBuilder.setPath((String)conf.contextPath().orNull(Predef$.MODULE$.$conforms()));
        return uriBuilder.build();
    }

    public static NodeDesc[] getNodes(RestApiUtils $this, CloudV3 cloudV3) {
        return (NodeDesc[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])cloudV3.nodes).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final NodeDesc apply(Tuple2<CloudV3.NodeV3, Object> x0$1) {
                Tuple2<CloudV3.NodeV3, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    CloudV3.NodeV3 node = (CloudV3.NodeV3)tuple2._1();
                    int idx = tuple2._2$mcI$sp();
                    String[] splits = node.ip_port.split(":");
                    String ip = splits[0];
                    int port = new StringOps(Predef$.MODULE$.augmentString(splits[1])).toInt();
                    NodeDesc nodeDesc = new NodeDesc(((Object)BoxesRunTime.boxToInteger((int)idx)).toString(), ip, port);
                    return nodeDesc;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(NodeDesc.class)));
    }

    private static String executeStringRapidsExpression(RestApiUtils $this, H2OConf conf, String expression) {
        URI endpoint = $this.getClusterEndpoint(conf);
        Map params = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ast"), (Object)expression)}));
        RapidsStringV3 result = (RapidsStringV3)$this.update(endpoint, "/99/Rapids", conf, (Map<String, Object>)params, $this.update$default$5(), $this.update$default$6(), ClassTag$.MODULE$.apply(RapidsStringV3.class));
        return result.string;
    }

    public static String getTimeZone(RestApiUtils $this, H2OConf conf) {
        return RestApiUtils$class.executeStringRapidsExpression($this, conf, "(getTimeZone)");
    }

    public static void setTimeZone(RestApiUtils $this, H2OConf conf, String timezone) {
        String expression = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(setTimeZone \"", "\")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{timezone}));
        RestApiUtils$class.executeStringRapidsExpression($this, conf, expression);
    }

    public static void setLogLevel(RestApiUtils $this, H2OConf conf, String logLevel) {
        URI endpoint = $this.getClusterEndpoint(conf);
        Map params = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"log_level"), (Object)logLevel)}));
        $this.update(endpoint, "/3/LogLevel", conf, (Map<String, Object>)params, $this.update$default$5(), $this.update$default$6(), ClassTag$.MODULE$.apply(LogLevelV3.class));
    }

    public static String getLogLevel(RestApiUtils $this, H2OConf conf) {
        URI endpoint = $this.getClusterEndpoint(conf);
        return ((LogLevelV3)$this.query((URI)endpoint, (String)"/3/LogLevel", (H2OConf)conf, $this.query$default$4(), $this.query$default$5(), (Enumeration.Value)$this.query$default$6(), ClassTag$.MODULE$.apply(LogLevelV3.class))).log_level;
    }

    public static void $init$(RestApiUtils $this) {
    }
}

