/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.h2o.backends.internal;

import ai.h2o.sparkling.H2OConf;
import ai.h2o.sparkling.backend.NodeDesc;
import java.net.InetAddress;
import org.apache.spark.SparkEnv$;
import org.apache.spark.h2o.backends.internal.CheckClusterSizeMsg$;
import org.apache.spark.h2o.backends.internal.FlatFileMsg;
import org.apache.spark.h2o.backends.internal.GetLeaderNodeMsg$;
import org.apache.spark.h2o.backends.internal.InternalH2OBackend$;
import org.apache.spark.h2o.backends.internal.LockClusterMsg$;
import org.apache.spark.h2o.backends.internal.StartH2OWorkersMsg;
import org.apache.spark.h2o.backends.internal.StopEndpointMsg$;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcCallContext;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.ThreadSafeRpcEndpoint;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import water.H2O;
import water.H2ONode;
import water.Paxos;
import water.util.Log;

@ScalaSignature(bytes="\u0006\u0001y2A!\u0001\u0002\u0001\u001f\tq\u0001JM(Sa\u000e,e\u000e\u001a9pS:$(BA\u0002\u0005\u0003!Ig\u000e^3s]\u0006d'BA\u0003\u0007\u0003!\u0011\u0017mY6f]\u0012\u001c(BA\u0004\t\u0003\rA'g\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011c\u0001\u0001\u0011-A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001a\u0004\"a\u0006\u000e\u000e\u0003aQ!!\u0007\u0005\u0002\u0007I\u00048-\u0003\u0002\u001c1\t)B\u000b\u001b:fC\u0012\u001c\u0016MZ3Sa\u000e,e\u000e\u001a9pS:$\b\u0002C\u000f\u0001\u0005\u000b\u0007I\u0011\t\u0010\u0002\rI\u00048-\u00128w+\u0005y\u0002CA\f!\u0013\t\t\u0003D\u0001\u0004Sa\u000e,eN\u001e\u0005\tG\u0001\u0011\t\u0011)A\u0005?\u00059!\u000f]2F]Z\u0004\u0003\"B\u0013\u0001\t\u00031\u0013A\u0002\u001fj]&$h\b\u0006\u0002(SA\u0011\u0001\u0006A\u0007\u0002\u0005!)Q\u0004\na\u0001?!)1\u0006\u0001C!Y\u00059!/Z2fSZ,W#A\u0017\u0011\tEq\u0003gM\u0005\u0003_I\u0011q\u0002U1si&\fGNR;oGRLwN\u001c\t\u0003#EJ!A\r\n\u0003\u0007\u0005s\u0017\u0010\u0005\u0002\u0012i%\u0011QG\u0005\u0002\u0005+:LG\u000fC\u00038\u0001\u0011\u0005\u0003(A\bsK\u000e,\u0017N^3B]\u0012\u0014V\r\u001d7z)\ti\u0013\bC\u0003;m\u0001\u00071(A\u0004d_:$X\r\u001f;\u0011\u0005]a\u0014BA\u001f\u0019\u00059\u0011\u0006oY\"bY2\u001cuN\u001c;fqR\u0004")
public class H2ORpcEndpoint
implements ThreadSafeRpcEndpoint {
    private final RpcEnv rpcEnv;

    public final RpcEndpointRef self() {
        return RpcEndpoint.class.self((RpcEndpoint)this);
    }

    public void onError(Throwable cause) {
        RpcEndpoint.class.onError((RpcEndpoint)this, (Throwable)cause);
    }

    public void onConnected(RpcAddress remoteAddress) {
        RpcEndpoint.class.onConnected((RpcEndpoint)this, (RpcAddress)remoteAddress);
    }

    public void onDisconnected(RpcAddress remoteAddress) {
        RpcEndpoint.class.onDisconnected((RpcEndpoint)this, (RpcAddress)remoteAddress);
    }

    public void onNetworkError(Throwable cause, RpcAddress remoteAddress) {
        RpcEndpoint.class.onNetworkError((RpcEndpoint)this, (Throwable)cause, (RpcAddress)remoteAddress);
    }

    public void onStart() {
        RpcEndpoint.class.onStart((RpcEndpoint)this);
    }

    public void onStop() {
        RpcEndpoint.class.onStop((RpcEndpoint)this);
    }

    public final void stop() {
        RpcEndpoint.class.stop((RpcEndpoint)this);
    }

    public RpcEnv rpcEnv() {
        return this.rpcEnv;
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ H2ORpcEndpoint $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof FlatFileMsg) {
                    FlatFileMsg flatFileMsg = (FlatFileMsg)A1;
                    NodeDesc[] nodes = flatFileMsg.nodes();
                    int portOffset = flatFileMsg.portOffset();
                    Predef$.MODULE$.refArrayOps((Object[])nodes).map((Function1)new Serializable(this, portOffset){
                        public static final long serialVersionUID = 0L;
                        private final int portOffset$1;

                        public final boolean apply(NodeDesc pair) {
                            String ip = pair.hostname();
                            int internalH2OPort = pair.port() + this.portOffset$1;
                            H2ONode h2oNode = H2ONode.intern(InetAddress.getByName(ip), internalH2OPort);
                            Log.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Adding ", " to ", "'s flatfile"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{h2oNode, H2O.SELF})));
                            return H2O.addNodeToFlatfile(h2oNode);
                        }
                        {
                            this.portOffset$1 = portOffset$1;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Boolean()));
                    Log.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Full flatfile: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(H2O.getFlatfile()).asScala()).mkString(", ")})));
                    object = BoxedUnit.UNIT;
                } else if (StopEndpointMsg$.MODULE$.equals(A1)) {
                    this.$outer.stop();
                    object = BoxedUnit.UNIT;
                } else if (LockClusterMsg$.MODULE$.equals(A1)) {
                    Paxos.lockCloud("Locking the cloud from Sparkling Water as we have reached the expected cluster size.");
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof FlatFileMsg ? true : (StopEndpointMsg$.MODULE$.equals(object) ? true : LockClusterMsg$.MODULE$.equals(object));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> receiveAndReply(RpcCallContext context) {
        return new Serializable(this, context){
            public static final long serialVersionUID = 0L;
            private final RpcCallContext context$1;

            public final <A1, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof StartH2OWorkersMsg) {
                    StartH2OWorkersMsg startH2OWorkersMsg = (StartH2OWorkersMsg)A1;
                    H2OConf conf = startH2OWorkersMsg.conf();
                    NodeDesc nodeDesc = InternalH2OBackend$.MODULE$.startH2OWorker(conf);
                    this.context$1.reply((Object)nodeDesc);
                    object = BoxedUnit.UNIT;
                } else if (CheckClusterSizeMsg$.MODULE$.equals(A1)) {
                    this.context$1.reply((Object)BoxesRunTime.boxToInteger((int)H2O.CLOUD.size()));
                    object = BoxedUnit.UNIT;
                } else if (GetLeaderNodeMsg$.MODULE$.equals(A1)) {
                    None$ reply = H2O.SELF.isLeaderNode() ? new Some((Object)new NodeDesc(SparkEnv$.MODULE$.get().executorId(), H2O.SELF_ADDRESS.getHostAddress(), H2O.API_PORT)) : None$.MODULE$;
                    this.context$1.reply((Object)reply);
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x2) {
                Object object = x2;
                boolean bl = object instanceof StartH2OWorkersMsg ? true : (CheckClusterSizeMsg$.MODULE$.equals(object) ? true : GetLeaderNodeMsg$.MODULE$.equals(object));
                return bl;
            }
            {
                this.context$1 = context$1;
            }
        };
    }

    public H2ORpcEndpoint(RpcEnv rpcEnv) {
        this.rpcEnv = rpcEnv;
        RpcEndpoint.class.$init$((RpcEndpoint)this);
    }
}

