/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.ml.models;

import ai.h2o.sparkling.H2OConf;
import ai.h2o.sparkling.H2OContext$;
import ai.h2o.sparkling.backend.BuildInfo$;
import ai.h2o.sparkling.backend.NodeDesc;
import ai.h2o.sparkling.backend.utils.RestApiUtils$;
import ai.h2o.sparkling.backend.utils.RestCommunication;
import ai.h2o.sparkling.backend.utils.RestCommunication$LoggingLevel$;
import ai.h2o.sparkling.backend.utils.RestCommunication$class;
import ai.h2o.sparkling.backend.utils.RestEncodingUtils$class;
import ai.h2o.sparkling.ml.models.H2OBinaryModel;
import ai.h2o.sparkling.utils.ScalaUtils$;
import ai.h2o.sparkling.utils.SparkSessionUtils$;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hex.Model;
import java.io.DataInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import water.AutoBuffer;
import water.api.schemas3.ModelSchemaBaseV3;
import water.api.schemas3.ModelsV3;

public final class H2OBinaryModel$
implements RestCommunication {
    public static final H2OBinaryModel$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile RestCommunication$LoggingLevel$ LoggingLevel$module;

    static {
        new H2OBinaryModel$();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RestCommunication$LoggingLevel$ LoggingLevel$lzycompute() {
        H2OBinaryModel$ h2OBinaryModel$ = this;
        synchronized (h2OBinaryModel$) {
            if (this.LoggingLevel$module != null) return this.LoggingLevel$module;
            this.LoggingLevel$module = new RestCommunication$LoggingLevel$(this);
            return this.LoggingLevel$module;
        }
    }

    @Override
    public RestCommunication$LoggingLevel$ LoggingLevel() {
        return this.LoggingLevel$module == null ? this.LoggingLevel$lzycompute() : this.LoggingLevel$module;
    }

    @Override
    public <ResultType> ResultType query(URI endpoint, String suffix, H2OConf conf, Map<String, Object> params, Seq<Tuple2<Class<?>, String>> skippedFields, Enumeration.Value confirmationLoggingLevel, ClassTag<ResultType> evidence$1) {
        return (ResultType)RestCommunication$class.query(this, endpoint, suffix, conf, params, skippedFields, confirmationLoggingLevel, evidence$1);
    }

    @Override
    public <ResultType> ResultType update(URI endpoint, String suffix, H2OConf conf, Map<String, Object> params, Seq<Tuple2<Class<?>, String>> skippedFields, boolean encodeParamsAsJson, ClassTag<ResultType> evidence$2) {
        return (ResultType)RestCommunication$class.update(this, endpoint, suffix, conf, params, skippedFields, encodeParamsAsJson, evidence$2);
    }

    @Override
    public <ResultType> ResultType delete(URI endpoint, String suffix, H2OConf conf, Map<String, Object> params, Seq<Tuple2<Class<?>, String>> skippedFields, boolean encodeParamsAsJson, ClassTag<ResultType> evidence$3) {
        return (ResultType)RestCommunication$class.delete(this, endpoint, suffix, conf, params, skippedFields, encodeParamsAsJson, evidence$3);
    }

    @Override
    public OutputStream insertToNode(NodeDesc node, String suffix, H2OConf conf, Map<String, Object> params) {
        return RestCommunication$class.insertToNode(this, node, suffix, conf, params);
    }

    @Override
    public OutputStream insert(URI endpoint, String suffix, H2OConf conf, Function1<OutputStream, OutputStream> streamWrapper, Map<String, Object> params) {
        return RestCommunication$class.insert(this, endpoint, suffix, conf, streamWrapper, params);
    }

    @Override
    public void delete(URI endpoint, String suffix, H2OConf conf) {
        RestCommunication$class.delete(this, endpoint, suffix, conf);
    }

    @Override
    public <ResultType> ResultType request(URI endpoint, String requestType, String suffix, H2OConf conf, Map<String, Object> params, Seq<Tuple2<Class<?>, String>> skippedFields, boolean encodeParamsAsJson, Enumeration.Value confirmationLoggingLevel, ClassTag<ResultType> evidence$4) {
        return (ResultType)RestCommunication$class.request(this, endpoint, requestType, suffix, conf, params, skippedFields, encodeParamsAsJson, confirmationLoggingLevel, evidence$4);
    }

    @Override
    public <ResultType> ResultType deserialize(String content, Seq<Tuple2<Class<?>, String>> skippedFields, ClassTag<ResultType> evidence$5) {
        return (ResultType)RestCommunication$class.deserialize((RestCommunication)this, content, skippedFields, evidence$5);
    }

    @Override
    public <ResultType> ResultType deserialize(JsonElement content, Seq<Tuple2<Class<?>, String>> skippedFields, ClassTag<ResultType> evidence$6) {
        return (ResultType)RestCommunication$class.deserialize((RestCommunication)this, content, skippedFields, evidence$6);
    }

    @Override
    public JsonObject deserializeAsJsonObject(String content, Seq<Tuple2<Class<?>, String>> skippedFields) {
        return RestCommunication$class.deserializeAsJsonObject(this, content, skippedFields);
    }

    @Override
    public void downloadBinaryURLContent(URI endpoint, String suffix, H2OConf conf, File file) {
        RestCommunication$class.downloadBinaryURLContent(this, endpoint, suffix, conf, file);
    }

    @Override
    public void downloadStringURLContent(URI endpoint, String suffix, H2OConf conf, File file) {
        RestCommunication$class.downloadStringURLContent(this, endpoint, suffix, conf, file);
    }

    @Override
    public InputStream readURLContent(URI endpoint, String requestType, String suffix, H2OConf conf, Map<String, Object> params, boolean encodeParamsAsJson, Option<String> file, Enumeration.Value confirmationLoggingLevel) {
        return RestCommunication$class.readURLContent(this, endpoint, requestType, suffix, conf, params, encodeParamsAsJson, file, confirmationLoggingLevel);
    }

    @Override
    public void checkResponseCode(HttpURLConnection connection, Enumeration.Value confirmationLoggingLevel) {
        RestCommunication$class.checkResponseCode(this, connection, confirmationLoggingLevel);
    }

    @Override
    public <ResultType> Map<String, Object> update$default$4() {
        return RestCommunication$class.update$default$4(this);
    }

    @Override
    public <ResultType> Seq<Tuple2<Class<?>, String>> update$default$5() {
        return RestCommunication$class.update$default$5(this);
    }

    @Override
    public <ResultType> boolean update$default$6() {
        return RestCommunication$class.update$default$6(this);
    }

    @Override
    public <ResultType> Map<String, Object> query$default$4() {
        return RestCommunication$class.query$default$4(this);
    }

    @Override
    public <ResultType> Seq<Tuple2<Class<?>, String>> query$default$5() {
        return RestCommunication$class.query$default$5(this);
    }

    @Override
    public <ResultType> Enumeration.Value query$default$6() {
        return RestCommunication$class.query$default$6(this);
    }

    @Override
    public Map<String, Object> readURLContent$default$5() {
        return RestCommunication$class.readURLContent$default$5(this);
    }

    @Override
    public boolean readURLContent$default$6() {
        return RestCommunication$class.readURLContent$default$6(this);
    }

    @Override
    public Option<String> readURLContent$default$7() {
        return RestCommunication$class.readURLContent$default$7(this);
    }

    @Override
    public Enumeration.Value readURLContent$default$8() {
        return RestCommunication$class.readURLContent$default$8(this);
    }

    @Override
    public <ResultType> Map<String, Object> delete$default$4() {
        return RestCommunication$class.delete$default$4(this);
    }

    @Override
    public <ResultType> Seq<Tuple2<Class<?>, String>> delete$default$5() {
        return RestCommunication$class.delete$default$5(this);
    }

    @Override
    public <ResultType> boolean delete$default$6() {
        return RestCommunication$class.delete$default$6(this);
    }

    @Override
    public Map<String, Object> insertToNode$default$4() {
        return RestCommunication$class.insertToNode$default$4(this);
    }

    @Override
    public <ResultType> Map<String, Object> request$default$5() {
        return RestCommunication$class.request$default$5(this);
    }

    @Override
    public <ResultType> Seq<Tuple2<Class<?>, String>> request$default$6() {
        return RestCommunication$class.request$default$6(this);
    }

    @Override
    public <ResultType> boolean request$default$7() {
        return RestCommunication$class.request$default$7(this);
    }

    @Override
    public <ResultType> Enumeration.Value request$default$8() {
        return RestCommunication$class.request$default$8(this);
    }

    @Override
    public Function1<OutputStream, OutputStream> insert$default$4() {
        return RestCommunication$class.insert$default$4(this);
    }

    @Override
    public Map<String, Object> insert$default$5() {
        return RestCommunication$class.insert$default$5(this);
    }

    @Override
    public Enumeration.Value checkResponseCode$default$2() {
        return RestCommunication$class.checkResponseCode$default$2(this);
    }

    @Override
    public String stringifyPrimitiveParam(Object value) {
        return RestEncodingUtils$class.stringifyPrimitiveParam(this, value);
    }

    @Override
    public boolean isPrimitiveType(Object value) {
        return RestEncodingUtils$class.isPrimitiveType(this, value);
    }

    @Override
    public String stringifyArray(Object arr) {
        return RestEncodingUtils$class.stringifyArray(this, arr);
    }

    @Override
    public String stringifyMap(Map<?, ?> map) {
        return RestEncodingUtils$class.stringifyMap(this, map);
    }

    @Override
    public String stringifyPair(Tuple2<?, ?> pair) {
        return RestEncodingUtils$class.stringifyPair(this, pair);
    }

    @Override
    public String stringify(Object value) {
        return RestEncodingUtils$class.stringify(this, value);
    }

    @Override
    public String stringifyParams(Map<String, Object> params, boolean encodeParamsAsJson) {
        return RestEncodingUtils$class.stringifyParams(this, params, encodeParamsAsJson);
    }

    @Override
    public Map<String, Object> stringifyParams$default$1() {
        return RestEncodingUtils$class.stringifyParams$default$1(this);
    }

    @Override
    public boolean stringifyParams$default$2() {
        return RestEncodingUtils$class.stringifyParams$default$2(this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public boolean exists(String modelId) {
        H2OConf conf = H2OContext$.MODULE$.ensure((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return H2OContext$.MODULE$.ensure$default$1();
            }
        }).getConf();
        URI endpoint = RestApiUtils$.MODULE$.getClusterEndpoint(conf);
        ModelsV3 models = (ModelsV3)this.query(endpoint, "/3/Models", conf, this.query$default$4(), this.query$default$5(), this.query$default$6(), ClassTag$.MODULE$.apply(ModelsV3.class));
        return Predef$.MODULE$.refArrayOps((Object[])models.models).exists((Function1)new Serializable(modelId){
            public static final long serialVersionUID = 0L;
            private final String modelId$1;

            public final boolean apply(ModelSchemaBaseV3<? extends Model<Model, ?, ?>, ? extends ModelSchemaBaseV3<Model, ModelSchemaBaseV3>> x$1) {
                String string = x$1.model_id.name;
                String string2 = this.modelId$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.modelId$1 = modelId$1;
            }
        });
    }

    public H2OBinaryModel read(String path) {
        return this.read(path, (Option<String>)None$.MODULE$);
    }

    private String extractVersionFromModel(String path) {
        return (String)ScalaUtils$.MODULE$.withResource(SparkSessionUtils$.MODULE$.readHDFSFile(path), new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(InputStream fis) {
                return (String)ScalaUtils$.MODULE$.withResource(new DataInputStream(fis), new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(DataInputStream dis) {
                        byte[] arr = new byte[20];
                        dis.readFully(arr);
                        AutoBuffer ab = new AutoBuffer(arr);
                        int persistenceInfo = ab.get1U();
                        int magic = ab.get1U();
                        if (persistenceInfo != 28 || magic != 237) {
                            throw new RuntimeException("Invalid binary model");
                        }
                        return ab.getStr();
                    }
                });
            }
        });
    }

    private void checkVersion(String expected, String modelVersion) {
        String string = expected;
        String string2 = modelVersion;
        if (!(string == null ? string2 != null : !string.equals(string2)) || modelVersion.endsWith("99999")) {
            return;
        }
        throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           | The binary model has been trained in H2O of version\n           | ", " but you are currently running H2O version of ", ".\n           | Please make sure that running Sparkling Water/H2O-3 cluster and the loaded binary\n           | model correspond to the same H2O-3 version."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{modelVersion, expected})))).stripMargin());
    }

    public H2OBinaryModel read(String path, Option<String> modelIdOption) {
        String string;
        this.verifyH2OIsRunning();
        String modelVersion = this.extractVersionFromModel(path);
        this.checkVersion(BuildInfo$.MODULE$.H2OVersion(), modelVersion);
        if (modelIdOption.isDefined()) {
            string = (String)modelIdOption.get();
        } else {
            H2OConf conf = H2OContext$.MODULE$.ensure((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return H2OContext$.MODULE$.ensure$default$1();
                }
            }).getConf();
            URI endpoint = RestApiUtils$.MODULE$.getClusterEndpoint(conf);
            Map params = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dir"), (Object)SparkSessionUtils$.MODULE$.hdfsQualifiedPath(path)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"model_id"), (Object)"test")}));
            ModelsV3 modelsV3 = (ModelsV3)RestApiUtils$.MODULE$.update(endpoint, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/99/Models.bin/"})).s((Seq)Nil$.MODULE$), conf, (Map<String, Object>)params, RestApiUtils$.MODULE$.update$default$5(), RestApiUtils$.MODULE$.update$default$6(), ClassTag$.MODULE$.apply(ModelsV3.class));
            string = ((ModelSchemaBaseV3)Predef$.MODULE$.refArrayOps((Object[])((Object[])modelsV3.models)).head()).model_id.name;
        }
        String modelId = string;
        H2OBinaryModel model = new H2OBinaryModel(modelId);
        return (H2OBinaryModel)model.setBinaryModel(SparkSessionUtils$.MODULE$.readHDFSFile(path));
    }

    private void verifyH2OIsRunning() {
        if (H2OContext$.MODULE$.get().isEmpty()) {
            throw new IllegalArgumentException("To use features available on a binary model, H2O Context has to be running!");
        }
    }

    private Object readResolve() {
        return MODULE$;
    }

    private H2OBinaryModel$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        RestEncodingUtils$class.$init$(this);
        RestCommunication$class.$init$(this);
    }
}

