/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import org.apache.commons.codec.binary.Base64;

public class H2OCredentials
implements Serializable {
    private final String _user;
    private final String _password;
    private static final String __TYPE = "MD5:";
    private static final Object __md5Lock = new Object();
    private static MessageDigest __md;

    public H2OCredentials() {
        this._user = null;
        this._password = null;
    }

    public H2OCredentials(String user, String password) {
        this._user = user;
        this._password = password;
    }

    public String toBasicAuth() {
        return "Basic " + H2OCredentials.base64EncodeToString(this._user + ":" + this._password);
    }

    public String toHashFileEntry() {
        return this._user + ": " + H2OCredentials.credentialMD5digest(this._password) + "\n";
    }

    public String toDebugString() {
        return "Credentials[_user='" + this._user + "', _password='" + this._password + "']";
    }

    private static String base64EncodeToString(String s2) {
        byte[] bytes = s2.getBytes(StandardCharsets.ISO_8859_1);
        return Base64.encodeBase64String((byte[])bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String credentialMD5digest(String password) {
        try {
            byte[] digest;
            Object object = __md5Lock;
            synchronized (object) {
                if (__md == null) {
                    try {
                        __md = MessageDigest.getInstance("MD5");
                    }
                    catch (Exception e2) {
                        throw new IllegalStateException(e2);
                    }
                }
                __md.reset();
                __md.update(password.getBytes(StandardCharsets.ISO_8859_1));
                digest = __md.digest();
            }
            return __TYPE + H2OCredentials.toString(digest, 16);
        }
        catch (Exception e3) {
            throw new IllegalStateException(e3);
        }
    }

    private static String toString(byte[] bytes, int base) {
        StringBuilder buf = new StringBuilder();
        for (byte b2 : bytes) {
            int bi = 0xFF & b2;
            int c2 = 48 + bi / base % base;
            if (c2 > 57) {
                c2 = 97 + (c2 - 48 - 10);
            }
            buf.append((char)c2);
            c2 = 48 + bi % base;
            if (c2 > 57) {
                c2 = 97 + (c2 - 48 - 10);
            }
            buf.append((char)c2);
        }
        return buf.toString();
    }
}

