/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.backend.external;

import ai.h2o.sparkling.H2OConf;
import ai.h2o.sparkling.backend.external.K8sH2OStatefulSet;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.Filterable;
import io.fabric8.kubernetes.client.dsl.Listable;
import io.fabric8.kubernetes.client.dsl.Nameable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public abstract class K8sH2OStatefulSet$class {
    public static String installH2OStatefulSet(K8sH2OStatefulSet $this, KubernetesClient client, H2OConf conf, String headlessServiceURL) {
        List resource = (List)client.load(K8sH2OStatefulSet$class.spec($this, conf, headlessServiceURL)).get();
        client.resourceList((Collection)resource).createOrReplace();
        return K8sH2OStatefulSet$class.waitForClusterToBeReady($this, client, conf);
    }

    public static void deleteH2OStatefulSet(K8sH2OStatefulSet $this, KubernetesClient client, H2OConf conf) {
        ((Deletable)((Nameable)client.apps().statefulSets().inNamespace(conf.externalK8sNamespace())).withName(conf.externalK8sH2OStatefulsetName())).delete();
    }

    private static String waitForClusterToBeReady(K8sH2OStatefulSet $this, KubernetesClient client, H2OConf conf) {
        long start = System.currentTimeMillis();
        int timeout = conf.cloudTimeout();
        while (System.currentTimeMillis() - start < (long)timeout) {
            Pod[] readyPods;
            Pod[] currentPods = K8sH2OStatefulSet$class.getPodsForStatefulSet($this, client, conf);
            if (currentPods.length == new StringOps(Predef$.MODULE$.augmentString((String)conf.clusterSize().get())).toInt() && (readyPods = K8sH2OStatefulSet$class.listReadyPods($this, currentPods, client, conf)).length == 1) {
                return ((Pod)Predef$.MODULE$.refArrayOps((Object[])readyPods).head()).getMetadata().getName();
            }
            Thread.sleep(100L);
        }
        throw new RuntimeException("Timeout during clouding of external H2O backend on K8s.");
    }

    private static Pod[] getPodsForStatefulSet(K8sH2OStatefulSet $this, KubernetesClient client, H2OConf conf) {
        return (Pod[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((PodList)((Listable)((Filterable)client.pods().inNamespace(conf.externalK8sNamespace())).withLabels(K8sH2OStatefulSet$class.convertLabelToMap($this, conf.externalK8sH2OLabel()))).list()).getItems()).asScala()).filter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Pod x$1) {
                String string = x$1.getStatus().getPhase();
                String string2 = "Running";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        })).toArray(ClassTag$.MODULE$.apply(Pod.class));
    }

    private static java.util.Map convertLabelToMap(K8sH2OStatefulSet $this, String label) {
        String[] split2 = label.split("=");
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)split2[0]), (Object)split2[1])}))).asJava();
    }

    private static Pod[] listReadyPods(K8sH2OStatefulSet $this, Pod[] pods, KubernetesClient client, H2OConf conf) {
        return (Pod[])Predef$.MODULE$.refArrayOps((Object[])pods).filter((Function1)new Serializable($this, client, conf){
            public static final long serialVersionUID = 0L;
            private final KubernetesClient client$1;
            private final H2OConf conf$1;

            public final boolean apply(Pod pod) {
                PodResource newPod = (PodResource)((Nameable)this.client$1.pods().inNamespace(this.conf$1.externalK8sNamespace())).withName(pod.getMetadata().getName());
                return Predef$.MODULE$.Boolean2boolean(newPod.isReady()) && ((String)newPod.getLog()).contains(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Created cluster of size ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.conf$1.clusterSize().get()})));
            }
            {
                this.client$1 = client$1;
                this.conf$1 = conf$1;
            }
        });
    }

    private static int getNthreades(K8sH2OStatefulSet $this, H2OConf conf) {
        return conf.nthreads() > 0 ? conf.nthreads() : 1;
    }

    private static InputStream spec(K8sH2OStatefulSet $this, H2OConf conf, String headlessServiceURL) {
        String spec = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n                  |apiVersion: apps/v1\n                  |kind: StatefulSet\n                  |metadata:\n                  |  name: ", "\n                  |  namespace: ", "\n                  |spec:\n                  |  serviceName: ", "\n                  |  podManagementPolicy: \"Parallel\"\n                  |  replicas: ", "\n                  |  selector:\n                  |    matchLabels:\n                  |      ", "\n                  |  template:\n                  |    metadata:\n                  |      labels:\n                  |        ", "\n                  |    spec:\n                  |      terminationGracePeriodSeconds: 10\n                  |      containers:\n                  |        - name: ", "\n                  |          image: '", "'\n                  |          resources:\n                  |            requests:\n                  |              cpu: ", "\n                  |              memory: \"", "\"\n                  |            limits:\n                  |              cpu: ", "\n                  |              memory: \"", "\"\n                  |          ports:\n                  |            - containerPort: 54321\n                  |              protocol: TCP\n                  |          readinessProbe:\n                  |            httpGet:\n                  |              path: /kubernetes/isLeaderNode\n                  |              port: ", "\n                  |            initialDelaySeconds: 5\n                  |            periodSeconds: 5\n                  |            failureThreshold: 1\n                  |          env:\n                  |          - name: H2O_KUBERNETES_SERVICE_DNS\n                  |            value: ", "\n                  |          - name: H2O_NODE_LOOKUP_TIMEOUT\n                  |            value: '180'\n                  |          - name: H2O_NODE_EXPECTED_COUNT\n                  |            value: '", "'\n                  |          - name: H2O_KUBERNETES_API_PORT\n                  |            value: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{conf.externalK8sH2OStatefulsetName(), conf.externalK8sNamespace(), conf.externalK8sH2OServiceName(), conf.clusterSize().get(), $this.convertLabel(conf.externalK8sH2OLabel()), $this.convertLabel(conf.externalK8sH2OLabel()), conf.externalK8sH2OServiceName(), conf.externalK8sDockerImage(), BoxesRunTime.boxToInteger((int)K8sH2OStatefulSet$class.getNthreades($this, conf)), conf.externalMemory(), BoxesRunTime.boxToInteger((int)K8sH2OStatefulSet$class.getNthreades($this, conf)), conf.externalMemory(), BoxesRunTime.boxToInteger((int)conf.externalK8sH2OApiPort()), headlessServiceURL, conf.clusterSize().get(), BoxesRunTime.boxToInteger((int)conf.externalK8sH2OApiPort())})))).stripMargin();
        return new ByteArrayInputStream(spec.getBytes());
    }

    public static void $init$(K8sH2OStatefulSet $this) {
    }
}

