/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.h2o.backends.internal;

import ai.h2o.sparkling.H2OConf;
import ai.h2o.sparkling.H2OContext;
import ai.h2o.sparkling.backend.NodeDesc;
import ai.h2o.sparkling.backend.external.ExternalBackendConf$;
import ai.h2o.sparkling.backend.utils.SharedBackendUtils$class;
import ai.h2o.sparkling.utils.SparkSessionUtils$;
import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.expose.Utils$;
import org.apache.spark.h2o.backends.internal.CheckClusterSizeMsg$;
import org.apache.spark.h2o.backends.internal.FlatFileMsg;
import org.apache.spark.h2o.backends.internal.GetLeaderNodeMsg$;
import org.apache.spark.h2o.backends.internal.InternalBackendUtils;
import org.apache.spark.h2o.backends.internal.InternalBackendUtils$class;
import org.apache.spark.h2o.backends.internal.LockClusterMsg$;
import org.apache.spark.h2o.backends.internal.SpreadRDDBuilder;
import org.apache.spark.h2o.backends.internal.StartH2OWorkersMsg;
import org.apache.spark.h2o.backends.internal.StopEndpointMsg$;
import org.apache.spark.internal.Logging;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcTimeout;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerExecutorAdded;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.util.RpcUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Future;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import water.H2O;
import water.H2OStarter;
import water.hive.DelegationTokenRefresher;
import water.util.Log;

public final class InternalH2OBackend$
implements InternalBackendUtils {
    public static final InternalH2OBackend$ MODULE$;
    private final Seq<Tuple2<String, String>> UNSUPPORTED_SPARK_OPTIONS;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new InternalH2OBackend$();
    }

    @Override
    public void checkUnsupportedSparkOptions(Seq<Tuple2<String, String>> unsupportedSparkOptions, H2OConf conf) {
        InternalBackendUtils$class.checkUnsupportedSparkOptions(this, unsupportedSparkOptions, conf);
    }

    @Override
    public void setSelfAddressToH2ONode(Seq<String> h2oArgs) {
        InternalBackendUtils$class.setSelfAddressToH2ONode(this, h2oArgs);
    }

    @Override
    public Seq<String> getH2OWorkerArgs(H2OConf conf) {
        return InternalBackendUtils$class.getH2OWorkerArgs(this, conf);
    }

    @Override
    public Option<Object> guessTotalExecutorSize(SparkContext sc) {
        return InternalBackendUtils$class.guessTotalExecutorSize(this, sc);
    }

    @Override
    public String getHostname(SparkEnv env) {
        return SharedBackendUtils$class.getHostname(this, env);
    }

    @Override
    public void distributeFiles(H2OConf conf, SparkContext sc) {
        SharedBackendUtils$class.distributeFiles(this, conf, sc);
    }

    @Override
    public Seq<String> getH2OSecurityArgs(H2OConf conf) {
        return SharedBackendUtils$class.getH2OSecurityArgs(this, conf);
    }

    @Override
    public Seq<String> getH2OCommonArgs(H2OConf conf) {
        return SharedBackendUtils$class.getH2OCommonArgs(this, conf);
    }

    @Override
    public Seq<String> getH2OWorkerAsClientArgs(H2OConf conf) {
        return SharedBackendUtils$class.getH2OWorkerAsClientArgs(this, conf);
    }

    @Override
    public Seq<String> parseStringToHttpHeaderArgs(String headers) {
        return SharedBackendUtils$class.parseStringToHttpHeaderArgs(this, headers);
    }

    @Override
    public Seq<String> getExtraHttpHeaderArgs(H2OConf conf) {
        return SharedBackendUtils$class.getExtraHttpHeaderArgs(this, conf);
    }

    @Override
    public String[] toH2OArgs(Seq<String> h2oArgs, NodeDesc[] executors) {
        return SharedBackendUtils$class.toH2OArgs(this, h2oArgs, executors);
    }

    @Override
    public File createTempDir() {
        return SharedBackendUtils$class.createTempDir(this);
    }

    @Override
    public File saveFlatFileAsFile(String content) {
        return SharedBackendUtils$class.saveFlatFileAsFile(this, content);
    }

    @Override
    public String translateHostnameToIp(String hostname) {
        return SharedBackendUtils$class.translateHostnameToIp(this, hostname);
    }

    @Override
    public NodeDesc[] toH2OArgs$default$2() {
        return SharedBackendUtils$class.toH2OArgs$default$2(this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public NodeDesc org$apache$spark$h2o$backends$internal$InternalH2OBackend$$getLeaderNode(RpcEndpointRef[] endpoints, H2OConf conf) {
        RpcTimeout askTimeout = RpcUtils$.MODULE$.askRpcTimeout(conf.sparkConf());
        return (NodeDesc)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])endpoints).flatMap((Function1)new Serializable(askTimeout){
            public static final long serialVersionUID = 0L;
            private final RpcTimeout askTimeout$1;

            public final Iterable<NodeDesc> apply(RpcEndpointRef ref) {
                Future future = ref.ask((Object)GetLeaderNodeMsg$.MODULE$, ClassTag$.MODULE$.apply(Option.class));
                return Option$.MODULE$.option2Iterable((Option)this.askTimeout$1.awaitResult(future));
            }
            {
                this.askTimeout$1 = askTimeout$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(NodeDesc.class)))).head();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void org$apache$spark$h2o$backends$internal$InternalH2OBackend$$waitForClusterSize(RpcEndpointRef[] endpoints, H2OConf conf, int expectedSize) {
        start = System.currentTimeMillis();
        timeout = conf.cloudTimeout();
        while (true) {
            if (System.currentTimeMillis() - start >= (long)timeout) {
                return;
            }
            if (!this.isClusterOfExpectedSize(endpoints, conf, expectedSize)) ** GOTO lbl-1000
            return;
lbl-1000:
            // 1 sources

            {
                Thread.sleep(100L);
                continue;
            }
            break;
        }
    }

    public void org$apache$spark$h2o$backends$internal$InternalH2OBackend$$lockCloud(RpcEndpointRef[] endpoints) {
        ((RpcEndpointRef)Predef$.MODULE$.refArrayOps((Object[])endpoints).head()).send((Object)LockClusterMsg$.MODULE$);
    }

    private boolean isClusterOfExpectedSize(RpcEndpointRef[] endpoints, H2OConf conf, int expectedSize) {
        RpcTimeout askTimeout = RpcUtils$.MODULE$.askRpcTimeout(conf.sparkConf());
        return !Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])endpoints).map((Function1)new Serializable(askTimeout){
            public static final long serialVersionUID = 0L;
            private final RpcTimeout askTimeout$2;

            /*
             * WARNING - void declaration
             */
            public final int apply(RpcEndpointRef ref) {
                void var3_3;
                Future future = ref.ask((Object)CheckClusterSizeMsg$.MODULE$, ClassTag$.MODULE$.Int());
                int clusterSize = BoxesRunTime.unboxToInt((Object)this.askTimeout$2.awaitResult(future));
                return (int)var3_3;
            }
            {
                this.askTimeout$2 = askTimeout$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).exists((Function1)new Serializable(expectedSize){
            public static final long serialVersionUID = 0L;
            private final int expectedSize$1;

            public final boolean apply(int x$1) {
                return this.apply$mcZI$sp(x$1);
            }

            public boolean apply$mcZI$sp(int x$1) {
                return x$1 != this.expectedSize$1;
            }
            {
                this.expectedSize$1 = expectedSize$1;
            }
        });
    }

    @Override
    public H2OConf checkAndUpdateConf(H2OConf conf) {
        Object object;
        SharedBackendUtils$class.checkAndUpdateConf(this, conf);
        this.logWarning((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Increasing 'spark.locality.wait' to value 0 (Infinitive) as we need to ensure we run on the nodes with H2O"})).s((Seq)Nil$.MODULE$);
            }
        });
        conf.set("spark.locality.wait", "0");
        conf.getOption("spark.executor.instances").foreach((Function1)new Serializable(conf){
            public static final long serialVersionUID = 0L;
            private final H2OConf conf$1;

            public final H2OConf apply(String v2) {
                return this.conf$1.set("spark.ext.h2o.cluster.size", v2);
            }
            {
                this.conf$1 = conf$1;
            }
        });
        if (conf.contains("spark.scheduler.minRegisteredResourcesRatio") || SparkSessionUtils$.MODULE$.active().sparkContext().isLocal()) {
            object = BoxedUnit.UNIT;
        } else {
            this.logWarning((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "The property 'spark.scheduler.minRegisteredResourcesRatio' is not specified!\nWe recommend to pass `--conf spark.scheduler.minRegisteredResourcesRatio=1`";
                }
            });
            object = conf.set("spark.scheduler.minRegisteredResourcesRatio", "1");
        }
        Object object2 = conf.cloudName().isEmpty() ? conf.setCloudName(new StringBuilder().append((Object)"sparkling-water-").append((Object)System.getProperty("user.name", "cluster")).append((Object)"_").append((Object)conf.sparkConf().getAppId()).toString()) : BoxedUnit.UNIT;
        Object object3 = conf.hdfsConf().isEmpty() ? conf.setHdfsConf(SparkContext$.MODULE$.getOrCreate().hadoopConfiguration()) : BoxedUnit.UNIT;
        this.checkUnsupportedSparkOptions(this.UNSUPPORTED_SPARK_OPTIONS(), conf);
        this.distributeFiles(conf, SparkSessionUtils$.MODULE$.active().sparkContext());
        return conf;
    }

    public Seq<Tuple2<String, String>> UNSUPPORTED_SPARK_OPTIONS() {
        return this.UNSUPPORTED_SPARK_OPTIONS;
    }

    public void org$apache$spark$h2o$backends$internal$InternalH2OBackend$$startSingleH2OWorker(H2OConf conf) {
        Seq<String> args = this.getH2OWorkerAsClientArgs(conf);
        String[] launcherArgs = this.toH2OArgs(args, this.toH2OArgs$default$2());
        this.initializeH2OKerberizedHiveSupport(conf);
        if (conf.isDirectIpConfigurationEnabled()) {
            this.setSelfAddressToH2ONode((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])launcherArgs));
        }
        H2OStarter.start(launcherArgs, true);
        conf.set((String)ExternalBackendConf$.MODULE$.PROP_EXTERNAL_CLUSTER_REPRESENTATIVE()._1(), H2O.getIpPortString());
    }

    public NodeDesc startH2OWorker(H2OConf conf) {
        Seq<String> args = this.getH2OWorkerArgs(conf);
        String[] launcherArgs = this.toH2OArgs(args, this.toH2OArgs$default$2());
        this.initializeH2OKerberizedHiveSupport(conf);
        if (conf.isDirectIpConfigurationEnabled()) {
            this.setSelfAddressToH2ONode((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])launcherArgs));
        }
        H2OStarter.start(launcherArgs, true);
        return new NodeDesc(SparkEnv$.MODULE$.get().executorId(), H2O.SELF_ADDRESS.getHostAddress(), H2O.API_PORT);
    }

    public void org$apache$spark$h2o$backends$internal$InternalH2OBackend$$registerNewExecutorListener(H2OContext hc2) {
        if (!hc2.sparkContext().master().startsWith("local-cluster[") && hc2.getConf().isClusterTopologyListenerEnabled()) {
            hc2.sparkContext().addSparkListener((SparkListenerInterface)new SparkListener(){

                public void onExecutorAdded(SparkListenerExecutorAdded executorAdded) {
                    InternalH2OBackend$.MODULE$.log().warn("New spark executor joined the cloud, however it won't be used for the H2O computations.");
                }
            });
        }
    }

    public void org$apache$spark$h2o$backends$internal$InternalH2OBackend$$tearDownEndpoints(RpcEndpointRef[] endpoints) {
        Predef$.MODULE$.refArrayOps((Object[])endpoints).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(RpcEndpointRef x$2) {
                x$2.send((Object)StopEndpointMsg$.MODULE$);
            }
        });
    }

    public RpcEndpointRef[] org$apache$spark$h2o$backends$internal$InternalH2OBackend$$registerEndpoints(H2OContext hc2) {
        RpcEndpointRef[] endpoints = new SpreadRDDBuilder(hc2, this.guessTotalExecutorSize(SparkSessionUtils$.MODULE$.active().sparkContext())).build();
        H2OConf conf = hc2.getConf();
        RpcEndpointRef[] endpointsFinal = conf.numH2OWorkers().isDefined() && !conf.extraClusterNodes() ? (RpcEndpointRef[])Predef$.MODULE$.refArrayOps((Object[])endpoints).take(BoxesRunTime.unboxToInt((Object)conf.numH2OWorkers().get())) : endpoints;
        return (RpcEndpointRef[])Predef$.MODULE$.refArrayOps((Object[])endpointsFinal).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final RpcEndpointRef apply(RpcEndpointRef ref) {
                return SparkEnv$.MODULE$.get().rpcEnv().setupEndpointRef(ref.address(), ref.name());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RpcEndpointRef.class)));
    }

    public NodeDesc[] org$apache$spark$h2o$backends$internal$InternalH2OBackend$$startH2OWorkers(RpcEndpointRef[] endpoints, H2OConf conf) {
        RpcTimeout askTimeout = RpcUtils$.MODULE$.askRpcTimeout(conf.sparkConf());
        return (NodeDesc[])Predef$.MODULE$.refArrayOps((Object[])endpoints).map((Function1)new Serializable(conf, askTimeout){
            public static final long serialVersionUID = 0L;
            private final H2OConf conf$2;
            private final RpcTimeout askTimeout$3;

            /*
             * WARNING - void declaration
             */
            public final NodeDesc apply(RpcEndpointRef ref) {
                void var3_3;
                Future future = ref.ask((Object)new StartH2OWorkersMsg(this.conf$2), ClassTag$.MODULE$.apply(NodeDesc.class));
                NodeDesc node = (NodeDesc)this.askTimeout$3.awaitResult(future);
                Log.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"H2O's worker node ", " started."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{node})));
                return var3_3;
            }
            {
                this.conf$2 = conf$2;
                this.askTimeout$3 = askTimeout$3;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(NodeDesc.class)));
    }

    public void org$apache$spark$h2o$backends$internal$InternalH2OBackend$$distributeFlatFile(RpcEndpointRef[] endpoints, H2OConf conf, NodeDesc[] nodes) {
        Log.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Distributing worker nodes locations: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])nodes).mkString(",")})));
        Predef$.MODULE$.refArrayOps((Object[])endpoints).foreach((Function1)new Serializable(conf, nodes){
            public static final long serialVersionUID = 0L;
            private final H2OConf conf$3;
            private final NodeDesc[] nodes$1;

            public final void apply(RpcEndpointRef x$3) {
                x$3.send((Object)new FlatFileMsg(this.nodes$1, this.conf$3.internalPortOffset()));
            }
            {
                this.conf$3 = conf$3;
                this.nodes$1 = nodes$1;
            }
        });
    }

    private void initializeH2OKerberizedHiveSupport(H2OConf conf) {
        if (conf.isKerberizedHiveEnabled()) {
            Configuration configuration = new Configuration();
            conf.hiveHost().foreach((Function1)new Serializable(configuration){
                public static final long serialVersionUID = 0L;
                private final Configuration configuration$1;

                public final void apply(String x$4) {
                    this.configuration$1.set("h2o.hive.jdbc.host", x$4);
                }
                {
                    this.configuration$1 = configuration$1;
                }
            });
            conf.hivePrincipal().foreach((Function1)new Serializable(configuration){
                public static final long serialVersionUID = 0L;
                private final Configuration configuration$1;

                public final void apply(String x$5) {
                    this.configuration$1.set("h2o.hive.principal", x$5);
                }
                {
                    this.configuration$1 = configuration$1;
                }
            });
            conf.hiveJdbcUrlPattern().foreach((Function1)new Serializable(configuration){
                public static final long serialVersionUID = 0L;
                private final Configuration configuration$1;

                public final void apply(String x$6) {
                    this.configuration$1.set("h2o.hive.jdbc.urlPattern", x$6);
                }
                {
                    this.configuration$1 = configuration$1;
                }
            });
            conf.hiveToken().foreach((Function1)new Serializable(configuration){
                public static final long serialVersionUID = 0L;
                private final Configuration configuration$1;

                public final void apply(String x$7) {
                    this.configuration$1.set("h2o.hive.token", x$7);
                }
                {
                    this.configuration$1 = configuration$1;
                }
            });
            File sparkTmpDir = new File(Utils$.MODULE$.getLocalDir(SparkEnv$.MODULE$.get().conf()));
            DelegationTokenRefresher.setup(configuration, sparkTmpDir.getAbsolutePath());
        }
    }

    private Object readResolve() {
        return MODULE$;
    }

    private InternalH2OBackend$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        SharedBackendUtils$class.$init$(this);
        InternalBackendUtils$class.$init$(this);
        this.UNSUPPORTED_SPARK_OPTIONS = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"spark.dynamicAllocation.enabled", (Object)"true"), new Tuple2((Object)"spark.speculation", (Object)"true")}));
    }
}

