/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.h2o;

import java.net.URL;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.spark.Logging$;
import org.apache.spark.h2o.H2OLogging;
import org.apache.spark.h2o.H2OLogging$;
import org.apache.spark.util.Utils$;
import org.slf4j.impl.StaticLoggerBinder;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;

public abstract class H2OLogging$class {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initializeLogIfNecessary(H2OLogging $this, boolean isInterpreter) {
        if (H2OLogging$.MODULE$.org$apache$spark$h2o$H2OLogging$$initialized()) return;
        Object object = Logging$.MODULE$.initLock();
        synchronized (object) {
            BoxedUnit boxedUnit;
            if (H2OLogging$.MODULE$.org$apache$spark$h2o$H2OLogging$$initialized()) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                $this.initializeLogging(isInterpreter);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public static void initializeLogging(H2OLogging $this, boolean isInterpreter) {
        String binderClass = StaticLoggerBinder.getSingleton().getLoggerFactoryClassStr();
        boolean usingLog4j12 = "org.slf4j.impl.Log4jLoggerFactory".equals(binderClass);
        if (usingLog4j12) {
            boolean log4j12Initialized = LogManager.getRootLogger().getAllAppenders().hasMoreElements();
            if (!log4j12Initialized) {
                String defaultLogProps = "org/apache/spark/log4j-defaults.properties";
                Option option = Option$.MODULE$.apply((Object)Utils$.MODULE$.getSparkClassLoader().getResource(defaultLogProps));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    URL url = (URL)some.x();
                    PropertyConfigurator.configure((URL)url);
                    System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Using Spark's default log4j profile: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{defaultLogProps})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) {
                        throw new MatchError((Object)option);
                    }
                    System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Spark was unable to load ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{defaultLogProps})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            if (isInterpreter) {
                Level replLevel;
                Logger rootLogger = LogManager.getRootLogger();
                Logger replLogger = LogManager.getLogger((String)$this.logName());
                Level level = replLevel = (Level)Option$.MODULE$.apply((Object)replLogger.getLevel()).getOrElse((Function0)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final Level apply() {
                        return Level.WARN;
                    }
                });
                Level level2 = rootLogger.getEffectiveLevel();
                if (level == null ? level2 != null : !level.equals(level2)) {
                    System.err.printf("Setting default log level to \"%s\".\n", replLevel);
                    System.err.println("To adjust logging level use sc.setLogLevel(newLevel).");
                    rootLogger.setLevel(replLevel);
                }
            }
        }
        H2OLogging$.MODULE$.org$apache$spark$h2o$H2OLogging$$initialized_$eq(true);
        $this.log();
    }

    public static void $init$(H2OLogging $this) {
    }
}

