/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.utils;

import ai.h2o.sparkling.utils.CompatibilityObjectInputStream;
import ai.h2o.sparkling.utils.DataFrameSerializer;
import ai.h2o.sparkling.utils.ScalaUtils$;
import ai.h2o.sparkling.utils.SparkSessionUtils$;
import java.io.ByteArrayInputStream;
import java.util.Base64;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructType;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;

public final class DataFrameJsonSerialization$ {
    public static final DataFrameJsonSerialization$ MODULE$;

    static {
        new DataFrameJsonSerialization$();
    }

    public String encodeDataFrame(Dataset<Row> dataFrame, DataFrameSerializer serializer) {
        JsonAST.JNull$ ast;
        JsonAST.JNull$ jNull$;
        if (dataFrame == null) {
            jNull$ = JsonAST.JNull$.MODULE$;
        } else {
            JsonAST.JValue serializedValue = serializer.serialize(dataFrame);
            jNull$ = JsonAST.JObject$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{JsonAST.JField$.MODULE$.apply("serializer", (JsonAST.JValue)new JsonAST.JString(serializer.getClass().getName())), JsonAST.JField$.MODULE$.apply("value", serializedValue)}));
        }
        JsonAST.JNull$ x$1 = ast = jNull$;
        Formats x$2 = JsonMethods$.MODULE$.render$default$2((JsonAST.JValue)x$1);
        return JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)x$1, x$2));
    }

    public String encodeDataFrames(Dataset<Row>[] dataFrames, DataFrameSerializer serializer) {
        JsonAST.JNull$ encoded;
        JsonAST.JNull$ x$3 = encoded = dataFrames == null ? JsonAST.JNull$.MODULE$ : JsonAST.JObject$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{JsonAST.JField$.MODULE$.apply("serializer", (JsonAST.JValue)new JsonAST.JString(serializer.getClass().getName())), JsonAST.JField$.MODULE$.apply("dataframes", (JsonAST.JValue)new JsonAST.JArray((List)Predef$.MODULE$.refArrayOps((Object[])dataFrames).toList().map((Function1)new Serializable(serializer){
            public static final long serialVersionUID = 0L;
            private final DataFrameSerializer serializer$1;

            public final JsonAST.JValue apply(Dataset<Row> df) {
                return df == null ? JsonAST.JNull$.MODULE$ : this.serializer$1.serialize(df);
            }
            {
                this.serializer$1 = serializer$1;
            }
        }, List$.MODULE$.canBuildFrom())))}));
        Formats x$4 = JsonMethods$.MODULE$.render$default$2((JsonAST.JValue)x$3);
        return JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)x$3, x$4));
    }

    public Dataset<Row> decodeDataFrame(String json) {
        block5: {
            Dataset<Row> dataset;
            block3: {
                JsonAST.JValue jValue;
                block4: {
                    block2: {
                        jValue = JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(json), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
                        if (!JsonAST.JNull$.MODULE$.equals(jValue)) break block2;
                        dataset = null;
                        break block3;
                    }
                    if (!(jValue instanceof JsonAST.JObject)) break block4;
                    JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                    List fields = jObject.obj();
                    Map fieldsMap = fields.toMap(Predef$.MODULE$.$conforms());
                    String serializerClassName = ((JsonAST.JString)fieldsMap.apply((Object)"serializer")).values();
                    DataFrameSerializer serializer = (DataFrameSerializer)Class.forName(serializerClassName).newInstance();
                    JsonAST.JValue serializedValue = (JsonAST.JValue)fieldsMap.apply((Object)"value");
                    dataset = serializer.deserialize(serializedValue);
                    break block3;
                }
                if (!(jValue instanceof JsonAST.JString)) break block5;
                JsonAST.JString jString = (JsonAST.JString)jValue;
                String data = jString.s();
                byte[] bytes = Base64.getDecoder().decode(data);
                dataset = (Dataset<Row>)ScalaUtils$.MODULE$.withResource(new ByteArrayInputStream(bytes), new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Dataset<Row> apply(ByteArrayInputStream byteStream) {
                        return (Dataset)ScalaUtils$.MODULE$.withResource(new CompatibilityObjectInputStream(byteStream), new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Dataset<Row> apply(CompatibilityObjectInputStream objectStream) {
                                StructType schema = (StructType)objectStream.readObject();
                                java.util.List rows = (java.util.List)objectStream.readObject();
                                return SparkSessionUtils$.MODULE$.active().createDataFrame(rows, schema);
                            }
                        });
                    }
                });
            }
            return dataset;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot decode ", " to DataFrame."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{json})));
    }

    public Dataset<Row>[] decodeDataFrames(String json) {
        block4: {
            Dataset[] datasetArray;
            block3: {
                JsonAST.JValue jValue;
                block2: {
                    jValue = JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(json), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
                    if (!JsonAST.JNull$.MODULE$.equals(jValue)) break block2;
                    datasetArray = null;
                    break block3;
                }
                if (!(jValue instanceof JsonAST.JObject)) break block4;
                JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                List fields = jObject.obj();
                Map fieldsMap = fields.toMap(Predef$.MODULE$.$conforms());
                String serializerClassName = ((JsonAST.JString)fieldsMap.apply((Object)"serializer")).values();
                DataFrameSerializer serializer = (DataFrameSerializer)Class.forName(serializerClassName).newInstance();
                JsonAST.JValue serializedDataFrames = (JsonAST.JValue)fieldsMap.apply((Object)"dataframes");
                datasetArray = (Dataset[])((TraversableOnce)serializedDataFrames.children().map((Function1)new Serializable(serializer){
                    public static final long serialVersionUID = 0L;
                    private final DataFrameSerializer serializer$2;

                    public final Dataset<Row> apply(JsonAST.JValue x0$1) {
                        JsonAST.JValue jValue = x0$1;
                        Dataset<Row> dataset = JsonAST.JNull$.MODULE$.equals(jValue) ? null : this.serializer$2.deserialize(jValue);
                        return dataset;
                    }
                    {
                        this.serializer$2 = serializer$2;
                    }
                }, List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Dataset.class));
            }
            return datasetArray;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot decode ", " to Array[DataFrame]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{json})));
    }

    private DataFrameJsonSerialization$() {
        MODULE$ = this;
    }
}

