/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.utils;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import org.xerial.snappy.SnappyInputStream;
import org.xerial.snappy.SnappyOutputStream;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;

public final class Compression$ {
    public static Compression$ MODULE$;
    private final Seq<String> supportedCompressionTypes;
    private final String defaultCompression;

    static {
        new Compression$();
    }

    public Seq<String> supportedCompressionTypes() {
        return this.supportedCompressionTypes;
    }

    public String defaultCompression() {
        return this.defaultCompression;
    }

    public OutputStream compress(String compressionType, OutputStream outputStream) {
        OutputStream outputStream2;
        String string = this.validateCompressionType(compressionType);
        if ("NONE".equals(string)) {
            outputStream2 = outputStream;
        } else if ("DEFLATE".equals(string)) {
            outputStream2 = new DeflaterOutputStream(outputStream);
        } else if ("GZIP".equals(string)) {
            outputStream2 = new GZIPOutputStream(outputStream);
        } else if ("SNAPPY".equals(string)) {
            outputStream2 = new SnappyOutputStream(outputStream);
        } else {
            throw new MatchError((Object)string);
        }
        return outputStream2;
    }

    public InputStream decompress(String compressionType, InputStream inputStream) {
        InputStream inputStream2;
        String string = this.validateCompressionType(compressionType);
        if ("NONE".equals(string)) {
            inputStream2 = inputStream;
        } else if ("DEFLATE".equals(string)) {
            inputStream2 = new InflaterInputStream(inputStream);
        } else if ("GZIP".equals(string)) {
            inputStream2 = new GZIPInputStream(inputStream);
        } else if ("SNAPPY".equals(string)) {
            inputStream2 = new SnappyInputStream(inputStream);
        } else {
            throw new MatchError((Object)string);
        }
        return inputStream2;
    }

    /*
     * WARNING - void declaration
     */
    public String validateCompressionType(String compressionType) {
        void var2_2;
        String upperCompressionType = compressionType.toUpperCase();
        if (!this.supportedCompressionTypes().contains((Object)upperCompressionType)) {
            throw new IllegalArgumentException("s'$compressionType' is not supported compression type.");
        }
        return var2_2;
    }

    private Compression$() {
        MODULE$ = this;
        this.supportedCompressionTypes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NONE", "DEFLATE", "GZIP", "SNAPPY"}));
        this.defaultCompression = "SNAPPY";
    }
}

