/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.utils;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import org.xerial.snappy.SnappyInputStream;
import org.xerial.snappy.SnappyOutputStream;
import scala.MatchError;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;

public final class Compression$ {
    public static Compression$ MODULE$;
    private final Seq<String> supportedCompressionTypes;
    private final String defaultCompression;

    static {
        new Compression$();
    }

    public Seq<String> supportedCompressionTypes() {
        return this.supportedCompressionTypes;
    }

    public String defaultCompression() {
        return this.defaultCompression;
    }

    public OutputStream compress(String compressionType, OutputStream outputStream) {
        String string = this.validateCompressionType(compressionType);
        if ("NONE".equals(string)) {
            return outputStream;
        }
        if ("DEFLATE".equals(string)) {
            return new DeflaterOutputStream(outputStream);
        }
        if ("GZIP".equals(string)) {
            return new GZIPOutputStream(outputStream);
        }
        if ("SNAPPY".equals(string)) {
            return new SnappyOutputStream(outputStream);
        }
        throw new MatchError((Object)string);
    }

    public InputStream decompress(String compressionType, InputStream inputStream) {
        String string = this.validateCompressionType(compressionType);
        if ("NONE".equals(string)) {
            return inputStream;
        }
        if ("DEFLATE".equals(string)) {
            return new InflaterInputStream(inputStream);
        }
        if ("GZIP".equals(string)) {
            return new GZIPInputStream(inputStream);
        }
        if ("SNAPPY".equals(string)) {
            return new SnappyInputStream(inputStream);
        }
        throw new MatchError((Object)string);
    }

    public String validateCompressionType(String compressionType) {
        String upperCompressionType = compressionType.toUpperCase();
        if (!this.supportedCompressionTypes().contains((Object)upperCompressionType)) {
            throw new IllegalArgumentException("s'$compressionType' is not supported compression type.");
        }
        return upperCompressionType;
    }

    private Compression$() {
        MODULE$ = this;
        this.supportedCompressionTypes = (Seq)new .colon.colon((Object)"NONE", (List)new .colon.colon((Object)"DEFLATE", (List)new .colon.colon((Object)"GZIP", (List)new .colon.colon((Object)"SNAPPY", (List)Nil$.MODULE$))));
        this.defaultCompression = "SNAPPY";
    }
}

