/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.utils;

import ai.h2o.sparkling.utils.CompatibilityObjectInputStream;
import ai.h2o.sparkling.utils.DataFrameSerializer;
import ai.h2o.sparkling.utils.ScalaUtils$;
import ai.h2o.sparkling.utils.SparkSessionUtils$;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Base64;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructType;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;

public final class DataFrameJsonSerialization$ {
    public static DataFrameJsonSerialization$ MODULE$;

    static {
        new DataFrameJsonSerialization$();
    }

    public String encodeDataFrame(Dataset<Row> dataFrame, DataFrameSerializer serializer) {
        JsonAST.JNull$ ast;
        JsonAST.JNull$ jNull$;
        if (dataFrame == null) {
            jNull$ = JsonAST.JNull$.MODULE$;
        } else {
            JsonAST.JValue serializedValue = serializer.serialize(dataFrame);
            jNull$ = JsonAST.JObject$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{JsonAST.JField$.MODULE$.apply("serializer", (JsonAST.JValue)new JsonAST.JString(serializer.getClass().getName())), JsonAST.JField$.MODULE$.apply("value", serializedValue)}));
        }
        JsonAST.JNull$ x$1 = ast = jNull$;
        Formats x$2 = JsonMethods$.MODULE$.render$default$2((JsonAST.JValue)x$1);
        return JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)x$1, x$2));
    }

    public String encodeDataFrames(Dataset<Row>[] dataFrames, DataFrameSerializer serializer) {
        JsonAST.JNull$ encoded;
        JsonAST.JNull$ x$1 = encoded = dataFrames == null ? JsonAST.JNull$.MODULE$ : JsonAST.JObject$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{JsonAST.JField$.MODULE$.apply("serializer", (JsonAST.JValue)new JsonAST.JString(serializer.getClass().getName())), JsonAST.JField$.MODULE$.apply("dataframes", (JsonAST.JValue)new JsonAST.JArray((List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataFrames)).toList().map((Function1 & Serializable & scala.Serializable)df -> {
            if (df == null) {
                return JsonAST.JNull$.MODULE$;
            }
            return serializer.serialize((Dataset<Row>)df);
        }, List$.MODULE$.canBuildFrom())))}));
        Formats x$2 = JsonMethods$.MODULE$.render$default$2((JsonAST.JValue)x$1);
        return JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)x$1, x$2));
    }

    public Dataset<Row> decodeDataFrame(String json) {
        JsonAST.JValue jValue = JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(json), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
        if (JsonAST.JNull$.MODULE$.equals(jValue)) {
            return null;
        }
        if (jValue instanceof JsonAST.JObject) {
            JsonAST.JObject jObject = (JsonAST.JObject)jValue;
            List fields = jObject.obj();
            Map fieldsMap = fields.toMap(Predef$.MODULE$.$conforms());
            String serializerClassName = ((JsonAST.JString)fieldsMap.apply((Object)"serializer")).values();
            DataFrameSerializer serializer = (DataFrameSerializer)Class.forName(serializerClassName).newInstance();
            JsonAST.JValue serializedValue = (JsonAST.JValue)fieldsMap.apply((Object)"value");
            return serializer.deserialize(serializedValue);
        }
        if (jValue instanceof JsonAST.JString) {
            JsonAST.JString jString = (JsonAST.JString)jValue;
            String data = jString.s();
            byte[] bytes = Base64.getDecoder().decode(data);
            return (Dataset)ScalaUtils$.MODULE$.withResource(new ByteArrayInputStream(bytes), (Function1 & Serializable & scala.Serializable)byteStream -> (Dataset)ScalaUtils$.MODULE$.withResource(new CompatibilityObjectInputStream((InputStream)byteStream), (Function1 & Serializable & scala.Serializable)objectStream -> {
                StructType schema = (StructType)objectStream.readObject();
                java.util.List rows = (java.util.List)objectStream.readObject();
                return SparkSessionUtils$.MODULE$.active().createDataFrame(rows, schema);
            }));
        }
        throw new IllegalArgumentException(new StringBuilder(28).append("Cannot decode ").append(json).append(" to DataFrame.").toString());
    }

    public Dataset<Row>[] decodeDataFrames(String json) {
        JsonAST.JValue jValue = JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(json), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
        if (JsonAST.JNull$.MODULE$.equals(jValue)) {
            return null;
        }
        if (jValue instanceof JsonAST.JObject) {
            JsonAST.JObject jObject = (JsonAST.JObject)jValue;
            List fields = jObject.obj();
            Map fieldsMap = fields.toMap(Predef$.MODULE$.$conforms());
            String serializerClassName = ((JsonAST.JString)fieldsMap.apply((Object)"serializer")).values();
            DataFrameSerializer serializer = (DataFrameSerializer)Class.forName(serializerClassName).newInstance();
            JsonAST.JValue serializedDataFrames = (JsonAST.JValue)fieldsMap.apply((Object)"dataframes");
            return (Dataset[])((TraversableOnce)serializedDataFrames.children().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                JsonAST.JValue jValue = x0$1;
                if (JsonAST.JNull$.MODULE$.equals(jValue)) {
                    return null;
                }
                return serializer.deserialize(jValue);
            }, List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Dataset.class));
        }
        throw new IllegalArgumentException(new StringBuilder(35).append("Cannot decode ").append(json).append(" to Array[DataFrame].").toString());
    }

    private DataFrameJsonSerialization$() {
        MODULE$ = this;
    }
}

