/*
 * Decompiled with CFR 0.152.
 */
package biz.k11i.xgboost.gbm;

import biz.k11i.xgboost.config.PredictorConfiguration;
import biz.k11i.xgboost.gbm.GBBase;
import biz.k11i.xgboost.util.FVec;
import biz.k11i.xgboost.util.ModelReader;
import java.io.IOException;
import java.io.Serializable;

public class GBLinear
extends GBBase {
    private float[] weights;

    @Override
    public void loadModel(PredictorConfiguration config, ModelReader reader, boolean ignored_with_pbuffer) throws IOException {
        new ModelParam(reader);
        long len = reader.readLong();
        this.weights = len == 0L ? new float[(this.num_feature + 1) * this.num_output_group] : reader.readFloatArray((int)len);
    }

    @Override
    public float[] predict(FVec feat, int ntree_limit, float base_score) {
        float[] preds = new float[this.num_output_group];
        for (int gid = 0; gid < this.num_output_group; ++gid) {
            preds[gid] = this.pred(feat, gid, base_score);
        }
        return preds;
    }

    @Override
    public float predictSingle(FVec feat, int ntree_limit, float base_score) {
        if (this.num_output_group != 1) {
            throw new IllegalStateException("Can't invoke predictSingle() because this model outputs multiple values: " + this.num_output_group);
        }
        return this.pred(feat, 0, base_score);
    }

    float pred(FVec feat, int gid, float base_score) {
        float psum = this.bias(gid) + base_score;
        for (int fid = 0; fid < this.num_feature; ++fid) {
            float featValue = feat.fvalue(fid);
            if (Float.isNaN(featValue)) continue;
            psum += featValue * this.weight(fid, gid);
        }
        return psum;
    }

    @Override
    public int[] predictLeaf(FVec feat, int ntree_limit) {
        throw new UnsupportedOperationException("gblinear does not support predict leaf index");
    }

    @Override
    public String[] predictLeafPath(FVec feat, int ntree_limit) {
        throw new UnsupportedOperationException("gblinear does not support predict leaf path");
    }

    public float weight(int fid, int gid) {
        return this.weights[fid * this.num_output_group + gid];
    }

    public float bias(int gid) {
        return this.weights[this.num_feature * this.num_output_group + gid];
    }

    public int getNumFeature() {
        return this.num_feature;
    }

    public int getNumOutputGroup() {
        return this.num_output_group;
    }

    static class ModelParam
    implements Serializable {
        final int[] reserved;

        ModelParam(ModelReader reader) throws IOException {
            reader.readUnsignedInt();
            reader.readInt();
            this.reserved = reader.readIntArray(32);
        }
    }
}

