/*
 * Decompiled with CFR 0.152.
 */
package biz.k11i.xgboost.gbm;

import biz.k11i.xgboost.config.PredictorConfiguration;
import biz.k11i.xgboost.gbm.Dart;
import biz.k11i.xgboost.gbm.GBLinear;
import biz.k11i.xgboost.gbm.GBTree;
import biz.k11i.xgboost.util.FVec;
import biz.k11i.xgboost.util.ModelReader;
import java.io.IOException;
import java.io.Serializable;

public interface GradBooster
extends Serializable {
    public void setNumClass(int var1);

    public void setNumFeature(int var1);

    public void loadModel(PredictorConfiguration var1, ModelReader var2, boolean var3) throws IOException;

    public float[] predict(FVec var1, int var2, float var3);

    public float predictSingle(FVec var1, int var2, float var3);

    public int[] predictLeaf(FVec var1, int var2);

    public String[] predictLeafPath(FVec var1, int var2);

    public static class Factory {
        public static GradBooster createGradBooster(String name) {
            if ("gbtree".equals(name)) {
                return new GBTree();
            }
            if ("gblinear".equals(name)) {
                return new GBLinear();
            }
            if ("dart".equals(name)) {
                return new Dart();
            }
            throw new IllegalArgumentException(name + " is not supported model.");
        }
    }
}

