/*
 * Copyright 2017 The OpenDSP Project
 *
 * The OpenDSP Project licenses this file to you under the Apache License,
 * version 2.0 (the "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at:
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */
package ai.houyi.dorado.example.controller.helper;

import ai.houyi.dorado.rest.annotation.ExceptionAdvice;
import ai.houyi.dorado.rest.annotation.ExceptionType;

/**
 * 
 * @author wangwp
 */
@ExceptionAdvice
public class TestExceptionAdvice {

	@ExceptionType(MyException.class)
	public String handleException(MyException ex) {
		return "cause: " + ex.getClass().getName() + "," + ex.getMessage();
	}

	@ExceptionType(Exception.class)
	public String handleException(Exception ex) {
		return "use default exception handler,cause: " + ex.getClass().getName() + "," + ex.getMessage();
	}
}
