/*
 * Decompiled with CFR 0.152.
 */
package ai.houyi.dorado.swagger.springboot;

import ai.houyi.dorado.swagger.ext.ApiContext;
import ai.houyi.dorado.swagger.ext.ApiKey;
import ai.houyi.dorado.swagger.springboot.SwaggerProperties;
import io.swagger.models.Contact;
import io.swagger.models.Info;
import io.swagger.models.License;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={SwaggerProperties.class})
public class SwaggerAutoConfiguration {
    @Autowired
    private SwaggerProperties swaggerConfig;

    @Bean(name={"swaggerApiContext"})
    public ApiContext buildApiContext() {
        Info info = new Info();
        info.title(this.swaggerConfig.getTitle()).description(this.swaggerConfig.getDescription()).termsOfService(this.swaggerConfig.getTermsOfServiceUrl()).version(this.swaggerConfig.getVersion());
        SwaggerProperties.Contact contact = this.swaggerConfig.getContact();
        if (contact != null) {
            info.setContact(new Contact().email(contact.getEmail()).name(contact.getName()).url(contact.getUrl()));
        }
        info.setLicense(new License().name(this.swaggerConfig.getLicense()).url(this.swaggerConfig.getLicenseUrl()));
        ApiContext.Builder apiContextBuilder = ApiContext.builder().withInfo(info);
        SwaggerProperties.ApiKey apiKey = this.swaggerConfig.getApiKey();
        if (apiKey != null) {
            ApiKey _apiKey = ApiKey.builder().withIn(this.swaggerConfig.getApiKey().getIn()).withName(this.swaggerConfig.getApiKey().getName()).build();
            apiContextBuilder.withApiKey(_apiKey);
        }
        return apiContextBuilder.build();
    }
}

