/*
 * Decompiled with CFR 0.152.
 */
package ai.houyi.dorado.swagger.ui.controller;

import ai.houyi.dorado.rest.annotation.Controller;
import ai.houyi.dorado.rest.annotation.GET;
import ai.houyi.dorado.rest.annotation.Path;
import ai.houyi.dorado.rest.http.HttpRequest;
import ai.houyi.dorado.rest.http.HttpResponse;
import ai.houyi.dorado.rest.util.ClassLoaderUtils;
import ai.houyi.dorado.rest.util.IOUtils;
import ai.houyi.dorado.rest.util.LogUtils;
import java.io.InputStream;

@Controller
@Path(value="/swagger-ui.*")
public class SwaggerUIController {
    private static final String RESOURCE_PREFIX = "META-INF/resources/webjars/swagger-ui";

    @GET
    public void readStaticResource(HttpRequest request, HttpResponse response) {
        String uri = request.getRequestURI();
        LogUtils.info((String)String.format("access static resource uri: %s", uri));
        String resource = String.format("%s%s", RESOURCE_PREFIX, uri);
        byte[] data = IOUtils.readBytes((InputStream)ClassLoaderUtils.getStream((String)resource));
        if (uri.endsWith(".css")) {
            response.setHeader("content-type", "text/css;charset=UTF-8");
        } else if (uri.endsWith(".html")) {
            response.setHeader("content-type", "text/html;charset=UTF-8");
        } else if (uri.endsWith(".js")) {
            response.setHeader("content-type", "text/javascript;charset=UTF-8");
        } else if (uri.endsWith(".map")) {
            // empty if block
        }
        response.write(data);
    }
}

