/*
 * Decompiled with CFR 0.152.
 */
package mobi.f2time.dorado.swagger.ext;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.converter.ModelConverters;
import io.swagger.models.parameters.CookieParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.util.Json;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import mobi.f2time.dorado.rest.annotation.CookieParam;
import mobi.f2time.dorado.rest.annotation.HeaderParam;
import mobi.f2time.dorado.rest.annotation.Path;
import mobi.f2time.dorado.rest.annotation.PathVariable;
import mobi.f2time.dorado.rest.annotation.RequestParam;
import mobi.f2time.dorado.rest.http.MultipartFile;
import mobi.f2time.dorado.rest.util.MethodDescriptor;
import mobi.f2time.dorado.rest.util.TypeUtils;
import mobi.f2time.dorado.swagger.ext.SwaggerExtension;

public class DefaultParameterExtension
implements SwaggerExtension {
    final ObjectMapper mapper = Json.mapper();

    private void handleAdditionalAnnotation(List<Parameter> parameters, Annotation annotation, Type type, Set<Type> typesToSkip) {
    }

    private Property createProperty(Type type) {
        return this.enforcePrimitive(ModelConverters.getInstance().readAsProperty(type), 0);
    }

    private Property enforcePrimitive(Property in, int level) {
        if (in instanceof RefProperty) {
            return new StringProperty();
        }
        if (in instanceof ArrayProperty) {
            if (level == 0) {
                ArrayProperty array = (ArrayProperty)in;
                array.setItems(this.enforcePrimitive(array.getItems(), level + 1));
            } else {
                return new StringProperty();
            }
        }
        return in;
    }

    @Override
    public List<Parameter> extractParameters(List<Annotation> annotations, Type type, Set<Type> typesToSkip, Iterator<SwaggerExtension> chain, MethodDescriptor methodDescriptor) {
        if (this.shouldIgnoreType(type, typesToSkip)) {
            return new ArrayList<Parameter>();
        }
        Path methodPathAnno = methodDescriptor.getMethod().getAnnotation(Path.class);
        String operationPath = methodPathAnno != null ? methodPathAnno.value() : null;
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (MethodDescriptor.MethodParameter _parameter : methodDescriptor.getParameters()) {
            Property schema;
            FormParameter fp;
            FormParameter parameter = null;
            Class annotationType = _parameter.getAnnotationType();
            if (annotationType == MultipartFile.class) {
                parameter = fp = (FormParameter)((FormParameter)new FormParameter().type("file")).name(_parameter.getName());
            } else if (annotationType == RequestParam.class) {
                fp = (QueryParameter)new QueryParameter().name(_parameter.getName());
                schema = this.createProperty(type);
                if (schema != null) {
                    fp.setProperty(schema);
                }
                parameter = fp;
            } else if (annotationType == PathVariable.class) {
                fp = (PathParameter)new PathParameter().name(_parameter.getName());
                schema = this.createProperty(type);
                if (schema != null) {
                    fp.setProperty(schema);
                }
                parameter = fp;
            } else if (annotationType == HeaderParam.class) {
                HeaderParameter hp = (HeaderParameter)new HeaderParameter().name(_parameter.getName());
                schema = this.createProperty(type);
                if (schema != null) {
                    hp.setProperty(schema);
                }
                parameter = hp;
            } else if (annotationType == CookieParam.class) {
                CookieParameter cp = (CookieParameter)new CookieParameter().name(_parameter.getName());
                schema = this.createProperty(type);
                if (schema != null) {
                    cp.setProperty(schema);
                }
                parameter = cp;
            } else {
                this.handleAdditionalAnnotation(parameters, _parameter.getAnnotation(), type, typesToSkip);
            }
            if (parameter == null) {
                if (operationPath != null && operationPath.contains(String.format("{%s}", _parameter.getName()))) {
                    fp = (PathParameter)new PathParameter().name(_parameter.getName());
                    schema = this.createProperty(type);
                    if (schema != null) {
                        fp.setProperty(schema);
                    }
                    parameter = fp;
                } else if (!this.isRequestBodyParam(_parameter)) {
                    fp = (QueryParameter)new QueryParameter().name(_parameter.getName());
                    schema = this.createProperty(type);
                    if (schema != null) {
                        fp.setProperty(schema);
                    }
                    parameter = fp;
                }
            }
            if (parameter == null) continue;
            parameters.add((Parameter)parameter);
        }
        return parameters;
    }

    private boolean isRequestBodyParam(MethodDescriptor.MethodParameter _parameter) {
        Class type = _parameter.getType();
        if (byte[].class == type || InputStream.class == type) {
            return true;
        }
        return TypeUtils.isSerializableType((Class)type);
    }
}

