/*
 * Decompiled with CFR 0.152.
 */
package mobi.f2time.dorado.swagger;

import io.swagger.models.Swagger;
import java.util.HashSet;
import java.util.ServiceLoader;
import mobi.f2time.dorado.Dorado;
import mobi.f2time.dorado.rest.util.PackageScanner;
import mobi.f2time.dorado.swagger.EnableSwagger;
import mobi.f2time.dorado.swagger.Reader;
import mobi.f2time.dorado.swagger.ext.ApiInfoBuilder;

public class SwaggerFactory {
    private static Swagger swagger;
    private static ApiInfoBuilder apiInfoBuilder;

    public static Swagger getSwagger() {
        if (swagger != null) {
            return swagger;
        }
        Reader reader = new Reader(new Swagger());
        String[] packages = null;
        Class mainClass = Dorado.mainClass;
        EnableSwagger enableSwagger = mainClass.getAnnotation(EnableSwagger.class);
        if (enableSwagger != null) {
            packages = enableSwagger.value();
        }
        if (packages == null || packages.length == 0) {
            packages = Dorado.serverConfig.scanPackages();
        }
        if (packages == null || packages.length == 0) {
            packages = new String[]{mainClass.getPackage().getName()};
        }
        if (packages == null || packages.length == 0) {
            throw new IllegalArgumentException("\u7f3a\u5c11scanPackages\u8bbe\u7f6e");
        }
        HashSet classes = new HashSet();
        for (String pkg : packages) {
            try {
                classes.addAll(PackageScanner.scan((String)pkg));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Swagger _swagger = reader.read(classes);
        if (apiInfoBuilder != null) {
            _swagger.setInfo(apiInfoBuilder.buildInfo());
            _swagger.setSchemes(apiInfoBuilder.schemes());
        }
        swagger = _swagger;
        return _swagger;
    }

    public static void main(String[] args) throws Exception {
    }

    static {
        ServiceLoader<ApiInfoBuilder> apiInfoBuilders = ServiceLoader.load(ApiInfoBuilder.class);
        apiInfoBuilder = apiInfoBuilders.iterator().hasNext() ? apiInfoBuilders.iterator().next() : null;
        try {
            if (apiInfoBuilder == null && Dorado.isEnableSpring) {
                apiInfoBuilder = (ApiInfoBuilder)Dorado.beanContainer.getBean(ApiInfoBuilder.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

