/*
 * Decompiled with CFR 0.152.
 */
package ai.houyi.dorado.swagger;

import ai.houyi.dorado.Dorado;
import ai.houyi.dorado.rest.util.PackageScanner;
import ai.houyi.dorado.swagger.EnableSwagger;
import ai.houyi.dorado.swagger.Reader;
import ai.houyi.dorado.swagger.ext.ApiContext;
import ai.houyi.dorado.swagger.ext.ApiContextBuilder;
import ai.houyi.dorado.swagger.ext.ApiKey;
import io.swagger.models.Scheme;
import io.swagger.models.SecurityRequirement;
import io.swagger.models.Swagger;
import io.swagger.models.auth.ApiKeyAuthDefinition;
import io.swagger.models.auth.In;
import io.swagger.models.auth.SecuritySchemeDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.ServiceLoader;

public class SwaggerFactory {
    private static Swagger swagger;
    private static ApiContextBuilder apiContextBuilder;

    public static Swagger getSwagger() {
        if (swagger != null) {
            return swagger;
        }
        Reader reader = new Reader(new Swagger());
        String[] packages = null;
        Class mainClass = Dorado.mainClass;
        EnableSwagger enableSwagger = mainClass.getAnnotation(EnableSwagger.class);
        if (enableSwagger != null) {
            packages = enableSwagger.value();
        }
        if (packages == null || packages.length == 0) {
            packages = Dorado.serverConfig.scanPackages();
        }
        if (packages == null || packages.length == 0) {
            packages = new String[]{mainClass.getPackage().getName()};
        }
        if (packages == null || packages.length == 0) {
            throw new IllegalArgumentException("\u7f3a\u5c11scanPackages\u8bbe\u7f6e");
        }
        HashSet classes = new HashSet();
        for (String pkg : packages) {
            try {
                classes.addAll(PackageScanner.scan((String)pkg));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Swagger _swagger = reader.read(classes);
        _swagger.setSchemes(Arrays.asList(Scheme.HTTP, Scheme.HTTPS));
        if (apiContextBuilder == null) {
            swagger = _swagger;
            return _swagger;
        }
        ApiContext apiContext = apiContextBuilder.buildApiContext();
        if (apiContext == null) {
            swagger = _swagger;
            return _swagger;
        }
        ApiKey apiKey = apiContext.getApiKey();
        if (apiKey != null) {
            ApiKeyAuthDefinition apiKeyAuth = new ApiKeyAuthDefinition(apiKey.getName(), In.forValue((String)(apiKey.getIn() == null ? "header" : apiKey.getIn())));
            _swagger.securityDefinition("auth", (SecuritySchemeDefinition)apiKeyAuth);
            ArrayList<SecurityRequirement> securityRequirements = new ArrayList<SecurityRequirement>();
            SecurityRequirement sr = new SecurityRequirement();
            sr.requirement("auth");
            securityRequirements.add(sr);
            _swagger.setSecurity(securityRequirements);
        }
        if (apiContext.getInfo() != null) {
            _swagger.setInfo(apiContext.getInfo());
        }
        swagger = _swagger;
        return _swagger;
    }

    static {
        ServiceLoader<ApiContextBuilder> apiContextBuilders = ServiceLoader.load(ApiContextBuilder.class);
        apiContextBuilder = apiContextBuilders.iterator().hasNext() ? apiContextBuilders.iterator().next() : null;
        try {
            if (apiContextBuilder == null && Dorado.isEnableSpring) {
                apiContextBuilder = (ApiContextBuilder)Dorado.beanContainer.getBean(ApiContextBuilder.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

