/*
 * Decompiled with CFR 0.152.
 */
package mobi.f2time.dorado.hotswap;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.List;
import mobi.f2time.dorado.rest.util.IOUtils;
import mobi.f2time.dorado.rest.util.PackageScanner;

public class DoradoClassLoader
extends ClassLoader {
    private final List<String> hotswappedClassNames;
    private static ClassLoader parent;

    public DoradoClassLoader() {
        String classpath = parent.getResource("").getPath();
        this.hotswappedClassNames = PackageScanner.listAllClassNames(classpath);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.hotswappedClassNames.contains(name)) {
            String file = parent.getResource("").getPath() + File.separator + name.replace('.', '/') + ".class";
            byte[] data = this.readBytesFromFile(file);
            return this.defineClass(name, data, 0, data.length);
        }
        return super.loadClass(name);
    }

    private byte[] readBytesFromFile(String file) {
        try {
            return IOUtils.readBytes(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        try {
            parent = DoradoClassLoader.class.getClassLoader();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

