/*
 * Decompiled with CFR 0.152.
 */
package mobi.f2time.dorado.rest;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.protobuf.Message;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import mobi.f2time.dorado.rest.util.IOUtils;
import mobi.f2time.dorado.rest.util.ProtobufMessageDescriptors;

public interface ObjectSerializer {
    public static final ObjectSerializer JSON = new ObjectSerializer(){

        @Override
        public byte[] serialize(Object t) {
            return com.alibaba.fastjson.JSON.toJSONString((Object)t).getBytes(CharsetUtil.UTF_8);
        }

        @Override
        public Object deserialize(InputStream in, Class type) {
            String text = IOUtils.toString(in, CharsetUtil.UTF_8.name());
            return JSONObject.parseObject((String)text, (Class)type);
        }
    };
    public static final ObjectSerializer PROTOBUF = new ObjectSerializer(){

        @Override
        public byte[] serialize(Object t) {
            Message message = (Message)t;
            return message.toByteArray();
        }

        @Override
        public Object deserialize(InputStream in, Class type) {
            return ProtobufMessageDescriptors.newMessageForType(in, type);
        }
    };
    public static final ObjectSerializer DEFAULT = new ObjectSerializer(){

        @Override
        public byte[] serialize(Object t) {
            if (t instanceof Message) {
                return ((Message)t).toByteArray();
            }
            return com.alibaba.fastjson.JSON.toJSONBytes((Object)t, (SerializerFeature[])new SerializerFeature[0]);
        }

        @Override
        public Object deserialize(InputStream in, Class type) {
            try {
                if (Message.class.isAssignableFrom(type)) {
                    return ProtobufMessageDescriptors.newMessageForType(in, type);
                }
                return JSONObject.parseObject((InputStream)in, (Type)type, (Feature[])new Feature[0]);
            }
            catch (IOException iOException) {
                return null;
            }
        }
    };

    public byte[] serialize(Object var1);

    public Object deserialize(InputStream var1, Class var2);
}

