/*
 * Decompiled with CFR 0.152.
 */
package mobi.f2time.dorado.rest.controller;

import com.alibaba.fastjson.annotation.JSONField;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import mobi.f2time.dorado.rest.util.TracingThreadPoolExecutor;

public class DoradoStatus {
    private static DoradoStatus INSTANCE = new DoradoStatus();
    private AtomicInteger connections = new AtomicInteger(0);
    private AtomicInteger pendingRequests = new AtomicInteger(0);
    private AtomicLong totalRequests = new AtomicLong(0L);
    private AtomicLong handledRequests = new AtomicLong(0L);
    private int workerPoolSize;
    private int activePoolSize;
    @JSONField(serialize=false)
    private TracingThreadPoolExecutor workerPool;

    private DoradoStatus() {
    }

    public static DoradoStatus get() {
        return INSTANCE;
    }

    public DoradoStatus totalRequestsIncrement() {
        this.totalRequests.incrementAndGet();
        return this;
    }

    public DoradoStatus handledRequestsIncrement() {
        this.handledRequests.incrementAndGet();
        return this;
    }

    public DoradoStatus connectionIncrement() {
        this.connections.incrementAndGet();
        return this;
    }

    public DoradoStatus connectionDecrement() {
        this.connections.decrementAndGet();
        return this;
    }

    public DoradoStatus pendingRequestsIncrement() {
        this.pendingRequests.incrementAndGet();
        return this;
    }

    public DoradoStatus pendingRequestsDecrement() {
        this.pendingRequests.decrementAndGet();
        return this;
    }

    public int getConnections() {
        return this.connections.get();
    }

    public int getPendingRequests() {
        return this.pendingRequests.get();
    }

    public long getTotalRequests() {
        return this.totalRequests.get();
    }

    public long getHandledRequests() {
        return this.handledRequests.get();
    }

    public int getWorkerPoolSize() {
        this.workerPoolSize = this.workerPool.getPoolSize();
        return this.workerPoolSize;
    }

    public int getActivePoolSize() {
        this.activePoolSize = this.workerPool.getActiveCount();
        return this.activePoolSize;
    }

    public void workerPool(TracingThreadPoolExecutor workerPool) {
        this.workerPool = workerPool;
    }
}

