/*
 * Decompiled with CFR 0.152.
 */
package mobi.f2time.dorado.rest.router;

import io.netty.handler.codec.http.HttpMethod;
import java.lang.reflect.Method;
import mobi.f2time.dorado.exception.DoradoException;
import mobi.f2time.dorado.rest.MediaType;
import mobi.f2time.dorado.rest.MessageBodyConverter;
import mobi.f2time.dorado.rest.MessageBodyConverters;
import mobi.f2time.dorado.rest.ParameterValueResolver;
import mobi.f2time.dorado.rest.ParameterValueResolvers;
import mobi.f2time.dorado.rest.http.HttpRequest;
import mobi.f2time.dorado.rest.http.HttpResponse;
import mobi.f2time.dorado.rest.router.UriRoutingPath;
import mobi.f2time.dorado.rest.util.MediaTypeUtils;
import mobi.f2time.dorado.rest.util.MethodDescriptor;

public class UriRoutingController {
    private final MethodDescriptor methodDescriptor;
    private final UriRoutingPath uriRoutingPath;

    private UriRoutingController(UriRoutingPath uriRoutingPath, Class<?> clazz, Method method) {
        this.methodDescriptor = MethodDescriptor.create(clazz, method);
        this.uriRoutingPath = uriRoutingPath;
    }

    public static UriRoutingController create(UriRoutingPath uriRoutingPath, Class<?> clazz, Method method) {
        return new UriRoutingController(uriRoutingPath, clazz, method);
    }

    public Object invoke(HttpRequest request, HttpResponse response, String[] pathVariables) throws Exception {
        String contentType;
        MediaType requestMediaType;
        Method invokeMethod = this.methodDescriptor.getMethod();
        MediaType expectedMediaType = MediaType.valueOf(this.methodDescriptor.consume());
        if (!(HttpMethod.GET.name().equals(request.getMethod()) || HttpMethod.DELETE.name().equals(request.getMethod()) || expectedMediaType.isWildcardType() || (requestMediaType = MediaType.valueOf(contentType = request.getHeader("content-type"))).isCompatible(expectedMediaType) && requestMediaType != null)) {
            throw new DoradoException(String.format("Invalid request content_type, expected: [%s], actual: [%s]", this.methodDescriptor.consume(), contentType));
        }
        Object[] args = this.resolveParameters(request, response, pathVariables);
        if (this.methodDescriptor.getReturnType() == Void.TYPE) {
            invokeMethod.invoke(this.methodDescriptor.getInvokeTarget(), args);
        } else {
            Object result = invokeMethod.invoke(this.methodDescriptor.getInvokeTarget(), args);
            MediaType mediaType = MediaTypeUtils.defaultForType(this.methodDescriptor.getReturnType(), this.methodDescriptor.produce());
            MessageBodyConverter messageBodyConverter = MessageBodyConverters.getMessageBodyConverter(mediaType);
            response.setHeader("content-type".toString(), mediaType.toString());
            response.write(messageBodyConverter.writeMessageBody(result));
        }
        return null;
    }

    private Object[] resolveParameters(HttpRequest request, HttpResponse response, String[] pathVariables) {
        MethodDescriptor.MethodParameter[] methodParameters = this.methodDescriptor.getParameters();
        if (methodParameters.length == 0) {
            return null;
        }
        Object[] methodArgs = new Object[methodParameters.length];
        for (int i = 0; i < methodArgs.length; ++i) {
            int pathVariableIndex = this.uriRoutingPath.resolvePathIndex(methodParameters[i].getName());
            methodArgs[i] = this.resolveMethodArg(request, response, this.methodDescriptor, methodParameters[i], pathVariableIndex == -1 ? null : pathVariables[pathVariableIndex]);
        }
        return methodArgs;
    }

    private Object resolveMethodArg(HttpRequest request, HttpResponse response, MethodDescriptor desc, MethodDescriptor.MethodParameter methodParameter, String pathVariable) {
        Class<?> parameterAnnotationType = methodParameter.getAnnotationType();
        ParameterValueResolver parameterValueResolver = ParameterValueResolvers.getParameterValueResolver(parameterAnnotationType);
        return parameterValueResolver.resolveParameterValue(request, response, desc, methodParameter, pathVariable);
    }

    public String toString() {
        return "RouteController [methodDescriptor=" + this.methodDescriptor + "]";
    }
}

