/*
 * Decompiled with CFR 0.152.
 */
package mobi.f2time.dorado.rest.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.timeout.IdleStateHandler;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import mobi.f2time.dorado.hotswap.DoradoClassLoader;
import mobi.f2time.dorado.rest.http.impl.Webapp;
import mobi.f2time.dorado.rest.server.Dorado;
import mobi.f2time.dorado.rest.server.DoradoServerBuilder;
import mobi.f2time.dorado.rest.server.DoradoServerHandler;
import mobi.f2time.dorado.rest.util.ClassLoaderUtils;
import mobi.f2time.dorado.rest.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoradoServer {
    private static final Logger LOG = LoggerFactory.getLogger((String)"Dorado");
    private final DoradoServerBuilder builder;

    public DoradoServer(DoradoServerBuilder builder) {
        this.builder = builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        NioEventLoopGroup acceptor = new NioEventLoopGroup(this.builder.getAcceptors());
        NioEventLoopGroup worker = new NioEventLoopGroup(this.builder.getIoWorkers());
        ServerBootstrap bootstrap = null;
        try {
            bootstrap = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)acceptor, (EventLoopGroup)worker).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ChannelPipeline pipeline = ch.pipeline();
                    pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
                    pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(DoradoServer.this.builder.getMaxPacketLength())});
                    pipeline.addLast(new ChannelHandler[]{new IdleStateHandler(DoradoServer.this.builder.getMaxIdleTime(), 0, 0)});
                    pipeline.addLast(new ChannelHandler[]{DoradoServerHandler.create(DoradoServer.this.builder)});
                }
            });
            bootstrap.option(ChannelOption.SO_BACKLOG, (Object)this.builder.getBacklog());
            bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)true);
            bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)this.builder.getSendBuffer());
            bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)this.builder.getRecvBuffer());
            bootstrap.childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
            ChannelFuture f = bootstrap.bind(this.builder.getPort()).sync();
            String doradoAscii = IOUtils.toString(ClassLoaderUtils.getStream("dorado-ascii"));
            System.out.println(doradoAscii);
            System.out.println();
            Webapp.create(this.builder.scanPackages());
            if (this.builder.isDevMode()) {
                this.reloadWebappIfNeed();
            }
            LOG.info(String.format("Dorado application initialized with port(s): %d (http)", this.builder.getPort()));
            f.channel().closeFuture().sync();
        }
        catch (Throwable ex) {
            LOG.error("start dorado server failed, cause: ", ex);
        }
        finally {
            worker.shutdownGracefully();
            acceptor.shutdownGracefully();
        }
    }

    private void reloadWebappIfNeed() {
        String watchingClasspath = ClassLoaderUtils.getPath("");
        new Thread(() -> {
            try {
                this.reloadClassesIfNeed(watchingClasspath);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }).start();
    }

    private void reloadClassesIfNeed(String classpath) throws Exception {
        WatchService classFilesWatcher = FileSystems.getDefault().newWatchService();
        Path rootPath = Paths.get(classpath, new String[0]);
        rootPath.register(classFilesWatcher, StandardWatchEventKinds.ENTRY_MODIFY);
        List<Path> allWatchDirs = DoradoServer.recurseListFiles(rootPath);
        for (Path watchDir : allWatchDirs) {
            watchDir.register(classFilesWatcher, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
        }
        while (!Thread.currentThread().isInterrupted()) {
            try {
                WatchKey watchKey = classFilesWatcher.poll(10L, TimeUnit.MILLISECONDS);
                if (watchKey == null) continue;
                AtomicBoolean isNeedReload = new AtomicBoolean(false);
                List<WatchEvent<?>> watchEvents = watchKey.pollEvents();
                watchEvents.stream().forEach(event -> {
                    Path watchedPath = (Path)event.context();
                    try {
                        LOG.info("File {} changed in classpath, reload webapp", (Object)watchedPath.toString());
                        isNeedReload.compareAndSet(false, true);
                    }
                    catch (Exception ex) {
                        LOG.error("watching file changed error", (Throwable)ex);
                    }
                });
                watchKey.reset();
                if (!isNeedReload.get()) continue;
                Dorado.classLoader = new DoradoClassLoader();
                Webapp.get().reload();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                Thread.currentThread().interrupt();
            }
        }
    }

    private static List<Path> recurseListFiles(Path root) throws IOException {
        ArrayList<Path> results = new ArrayList<Path>();
        List pathList = Files.list(root).filter(p -> p.toFile().isDirectory()).collect(Collectors.toList());
        for (Path p2 : pathList) {
            results.add(p2);
            results.addAll(DoradoServer.recurseListFiles(p2));
        }
        return results;
    }
}

