/*
 * Decompiled with CFR 0.152.
 */
package mobi.f2time.dorado.rest.server;

import java.util.concurrent.LinkedBlockingQueue;
import mobi.f2time.dorado.rest.server.DoradoServer;
import mobi.f2time.dorado.rest.util.Constant;
import mobi.f2time.dorado.rest.util.PackageScanner;
import mobi.f2time.dorado.rest.util.TracingThreadPoolExecutor;

public final class DoradoServerBuilder {
    private static DoradoServerBuilder serverConfig;
    private int backlog = 512;
    private int acceptors = Constant.DEFAULT_ACCEPTOR_COUNT;
    private int ioWorkers = Constant.DEFAULT_IO_WORKER_COUNT;
    private int minWorkers = 100;
    private int maxWorkers = 100;
    private int maxConnection = Integer.MAX_VALUE;
    private int maxPendingRequest = 10000;
    private int maxIdleTime = 10;
    private int sendBuffer = 262144;
    private int recvBuffer = 262144;
    private int maxPacketLength = 0x100000;
    private String[] scanPackages;
    private boolean devMode;
    private TracingThreadPoolExecutor executor;
    private final int port;

    private DoradoServerBuilder(int port) {
        this.port = port;
    }

    public static DoradoServerBuilder forPort(int port) {
        return new DoradoServerBuilder(port);
    }

    public DoradoServerBuilder backlog(int backlog) {
        this.backlog = backlog;
        return this;
    }

    public DoradoServerBuilder acceptors(int acceptors) {
        this.acceptors = acceptors;
        return this;
    }

    public DoradoServerBuilder ioWorkers(int ioWorkers) {
        this.ioWorkers = ioWorkers;
        return this;
    }

    public DoradoServerBuilder minWorkers(int minWorkers) {
        this.minWorkers = minWorkers;
        return this;
    }

    public DoradoServerBuilder maxWorkers(int maxWorkers) {
        this.maxWorkers = maxWorkers;
        return this;
    }

    public DoradoServerBuilder maxIdleTime(int maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
        return this;
    }

    public DoradoServerBuilder sendBuffer(int sendBuffer) {
        this.sendBuffer = sendBuffer;
        return this;
    }

    public DoradoServerBuilder recvBuffer(int recvBuffer) {
        this.recvBuffer = recvBuffer;
        return this;
    }

    public DoradoServerBuilder maxConnection(int maxConnection) {
        this.maxConnection = maxConnection;
        return this;
    }

    public DoradoServerBuilder maxPendingRequest(int maxPendingRequest) {
        this.maxPendingRequest = maxPendingRequest;
        return this;
    }

    public DoradoServerBuilder maxPacketLength(int maxPacketLength) {
        this.maxPacketLength = maxPacketLength;
        return this;
    }

    public DoradoServerBuilder scanPackages(String ... packages) {
        this.scanPackages = packages;
        return this;
    }

    public DoradoServerBuilder devMode(boolean devMode) {
        this.devMode = devMode;
        return this;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public int getAcceptors() {
        return this.acceptors;
    }

    public int getIoWorkers() {
        return this.ioWorkers;
    }

    public int getMinWorkers() {
        return this.minWorkers;
    }

    public int getMaxWorkers() {
        return this.maxWorkers;
    }

    public int getMaxConnection() {
        return this.maxConnection;
    }

    public int getMaxPendingRequest() {
        return this.maxPendingRequest;
    }

    public boolean isDevMode() {
        return this.devMode;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public int getSendBuffer() {
        return this.sendBuffer;
    }

    public int getRecvBuffer() {
        return this.recvBuffer;
    }

    public int getMaxPacketLength() {
        return this.maxPacketLength;
    }

    public String[] scanPackages() {
        return this.scanPackages;
    }

    public TracingThreadPoolExecutor executor() {
        return this.executor;
    }

    public int getPort() {
        return this.port;
    }

    public DoradoServer build() {
        if (this.minWorkers > this.maxWorkers) {
            throw new IllegalArgumentException("minWorkers is greater than maxWorkers");
        }
        if (this.maxPendingRequest <= 0) {
            throw new IllegalArgumentException("maxPendingRequest must be greater than 0");
        }
        this.executor = new TracingThreadPoolExecutor(this.minWorkers, this.maxWorkers, new LinkedBlockingQueue<Runnable>(this.maxPendingRequest));
        if (!this.devMode) {
            this.executor.prestartAllCoreThreads();
        }
        serverConfig = this;
        return new DoradoServer(this);
    }

    public static void main(String[] args) throws Exception {
        PackageScanner.scan("");
    }

    public static DoradoServerBuilder get() {
        return serverConfig;
    }
}

