/*
 * Decompiled with CFR 0.152.
 */
package mobi.f2time.dorado.rest.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClassLoaderUtils {
    private static final Logger logger = LoggerFactory.getLogger(ClassLoaderUtils.class);
    private static final Properties EMPTY_PROPERTIES = new Properties();
    private static ClassLoader classLoader;

    public static String getPath(String resource) {
        return ClassLoaderUtils.getURL(resource).getPath();
    }

    public static URL getURL(String resource) {
        return ClassLoaderUtils.getClassLoader().getResource(resource);
    }

    public static Object getInstance(String clazzName) {
        try {
            return ClassLoaderUtils.loadClass(clazzName).newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Object newInstance(Class<?> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Class<?> loadClass(String name) {
        try {
            return ClassLoaderUtils.getClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static ClassLoader getClassLoader() {
        if (classLoader != null) {
            return classLoader;
        }
        classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader;
    }

    public static InputStream getStream(String resource) {
        return ClassLoaderUtils.getClassLoader().getResourceAsStream(resource);
    }

    public static InputStream getStreamNoJvmCache(String resource) {
        try {
            return ClassLoaderUtils.getClassLoader().getResource(resource).openStream();
        }
        catch (IOException ex) {
            logger.error("", (Throwable)ex);
            return null;
        }
    }

    public static Properties getProperties(String resource) {
        Properties properties = new Properties();
        try {
            InputStream is = ClassLoaderUtils.getStream(resource);
            if (is == null) {
                return EMPTY_PROPERTIES;
            }
            properties.load(is);
            return properties;
        }
        catch (IOException ex) {
            return EMPTY_PROPERTIES;
        }
    }

    public static Reader getReader(String resource) {
        InputStream is = ClassLoaderUtils.getStream(resource);
        if (is == null) {
            return null;
        }
        return new BufferedReader(new InputStreamReader(is));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getList(String resource) {
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader reader = (BufferedReader)ClassLoaderUtils.getReader(resource);
        if (null == reader) {
            return list;
        }
        String line = "";
        try {
            while ((line = reader.readLine()) != null) {
                list.add(line);
            }
        }
        catch (IOException ex) {
            logger.error("\u5c06\u8d44\u6e90\u6587\u4ef6\u8f6c\u5316\u4e3alist\u51fa\u73b0\u5f02\u5e38", (Throwable)ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    logger.warn(ex.getMessage());
                }
            }
        }
        return list;
    }
}

