/*
 * Decompiled with CFR 0.152.
 */
package mobi.f2time.dorado.rest.util;

import com.google.protobuf.Message;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import mobi.f2time.dorado.rest.DefaultParameterNameResolver;
import mobi.f2time.dorado.rest.ParameterNameResolver;
import mobi.f2time.dorado.rest.annotation.Consume;
import mobi.f2time.dorado.rest.annotation.Produce;
import mobi.f2time.dorado.rest.http.HttpRequest;
import mobi.f2time.dorado.rest.http.HttpResponse;
import mobi.f2time.dorado.rest.util.ClassLoaderUtils;
import mobi.f2time.dorado.rest.util.ProtobufMessageDescriptors;

public class MethodDescriptor {
    private final Class<?> clazz;
    private final Method method;
    private Annotation[] annotations;
    private Object invokeTarget;
    private Class<?> returnType;
    private MethodParameter[] methodParameters;
    private Consume consume;
    private Produce produce;

    private MethodDescriptor(Class<?> clazz, Method method) {
        this(clazz, method, new DefaultParameterNameResolver());
    }

    private MethodDescriptor(Class<?> clazz, Method method, ParameterNameResolver parameterNameResolver) {
        this.clazz = clazz;
        this.method = method;
        this.returnType = method.getReturnType();
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        String[] parameterNames = parameterNameResolver.getParameterNames(method);
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        this.invokeTarget = ClassLoaderUtils.newInstance(clazz);
        this.annotations = method.getAnnotations();
        this.consume = method.getAnnotation(Consume.class);
        this.produce = method.getAnnotation(Produce.class);
        this.methodParameters = new MethodParameter[method.getParameterCount()];
        for (int i = 0; i < method.getParameterCount(); ++i) {
            Annotation annotation = parameterAnnotations[i].length == 0 ? null : parameterAnnotations[i][0];
            Class<?> type = parameterTypes[i];
            String name = parameterNames[i];
            this.methodParameters[i] = MethodParameter.create(name, type, annotation);
            this.registerMessageDescriptorForTypeIfNeed(type);
        }
    }

    private void registerMessageDescriptorForTypeIfNeed(Class<?> type) {
        try {
            if (Message.class.isAssignableFrom(type)) {
                ProtobufMessageDescriptors.registerMessageDescriptorForType(type);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static MethodDescriptor create(Class<?> clazz, Method method) {
        MethodDescriptor methodDescriptor = new MethodDescriptor(clazz, method);
        return methodDescriptor;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public Method getMethod() {
        return this.method;
    }

    public MethodParameter[] getParameters() {
        return this.methodParameters;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public Object getInvokeTarget() {
        return this.invokeTarget;
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public String consume() {
        return this.consume == null ? "*/*" : this.consume.value();
    }

    public String produce() {
        return this.produce == null ? "*/*" : this.produce.value();
    }

    public static class MethodParameter {
        private String name;
        private Class<?> type;
        private Annotation annotation;
        private Class<?> annotationType;

        private MethodParameter(String name, Class<?> type, Annotation annotation) {
            this.name = name;
            this.type = type;
            this.annotation = annotation;
            Class<Annotation> clazz = this.annotationType = annotation == null ? null : annotation.annotationType();
            if (type == HttpRequest.class) {
                this.annotationType = HttpRequest.class;
            }
            if (type == HttpResponse.class) {
                this.annotationType = HttpResponse.class;
            }
        }

        public static MethodParameter create(String name, Class<?> type, Annotation annotation) {
            return new MethodParameter(name, type, annotation);
        }

        public String getName() {
            return this.name;
        }

        public Class<?> getType() {
            return this.type;
        }

        public Annotation getAnnotation() {
            return this.annotation;
        }

        public Class<?> getAnnotationType() {
            return this.annotationType;
        }

        public String toString() {
            return "MethodParameter [name=" + this.name + ", type=" + this.type + ", annotation=" + this.annotation + ", annotationType=" + this.annotationType + "]";
        }
    }
}

