/*
 * Decompiled with CFR 0.152.
 */
package mobi.f2time.dorado.rest.util;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import mobi.f2time.dorado.rest.controller.DoradoStatus;

public class TracingThreadPoolExecutor
extends ThreadPoolExecutor {
    private final AtomicInteger pendingTasks = new AtomicInteger();
    private final DoradoStatus serverStatus = DoradoStatus.get();

    public TracingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, 0L, TimeUnit.MILLISECONDS, workQueue);
        this.serverStatus.workerPool(this);
    }

    @Override
    public void execute(Runnable command) {
        super.execute(command);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        this.serverStatus.pendingRequestsIncrement();
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        this.serverStatus.pendingRequestsDecrement();
    }

    public int getPendingTasks() {
        return this.pendingTasks.get();
    }
}

