/*
 * Decompiled with CFR 0.152.
 */
package mobi.f2time.dorado.rest;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import mobi.f2time.dorado.exception.DoradoException;
import mobi.f2time.dorado.rest.ParameterNameResolver;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class LocalVariableTableParameterNameResolver
implements ParameterNameResolver {
    @Override
    public String[] getParameterNames(Method method) {
        final String methodName = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        final String[] parameterNames = new String[parameterTypes.length];
        if (parameterTypes == null || parameterTypes.length == 0) {
            return null;
        }
        boolean isStatic = Modifier.isStatic(method.getModifiers());
        final Type[] types = new Type[parameterTypes.length];
        final int[] lvtSlotIndex = new int[types.length];
        int nextIndex = isStatic ? 0 : 1;
        for (int i = 0; i < types.length; ++i) {
            types[i] = Type.getType(parameterTypes[i]);
            lvtSlotIndex[i] = nextIndex++;
            if (types[i] != Type.LONG_TYPE && types[i] != Type.DOUBLE_TYPE) continue;
            nextIndex += 2;
        }
        try {
            ClassReader classReader = new ClassReader(method.getDeclaringClass().getName());
            classReader.accept(new ClassVisitor(393216){

                public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                    Object[] argumentTypes = Type.getArgumentTypes((String)descriptor);
                    if (!methodName.equals(name) || !Arrays.equals(argumentTypes, types)) {
                        return super.visitMethod(access, name, descriptor, signature, exceptions);
                    }
                    return new MethodVisitor(393216){

                        public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
                            for (int i = 0; i < lvtSlotIndex.length; ++i) {
                                if (lvtSlotIndex[i] != index) continue;
                                parameterNames[i] = name;
                            }
                        }
                    };
                }
            }, 0);
        }
        catch (Exception ex) {
            String errorMsg = String.format("Get method parameter names error, method: %s", method.getName());
            throw new DoradoException(errorMsg, ex);
        }
        return parameterNames;
    }
}

