/*
 * Decompiled with CFR 0.152.
 */
package mobi.f2time.dorado.rest;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.protobuf.Message;
import io.netty.util.CharsetUtil;
import java.io.InputStream;
import mobi.f2time.dorado.exception.DoradoException;
import mobi.f2time.dorado.rest.ObjectSerializer;
import mobi.f2time.dorado.rest.util.IOUtils;
import mobi.f2time.dorado.rest.util.SerializeUtils;

public interface MessageBodyConverter<T> {
    public static final MessageBodyConverter<? extends Object> JSON = new MessageBodyConverter<Object>(){

        @Override
        public byte[] writeMessageBody(Object t) {
            return com.alibaba.fastjson.JSON.toJSONBytes((Object)t, (SerializerFeature[])new SerializerFeature[0]);
        }

        @Override
        public Object readMessageBody(InputStream in, Class clazz) {
            return JSONObject.parseObject((String)IOUtils.toString(in, CharsetUtil.UTF_8.name()), (Class)clazz);
        }
    };
    public static final MessageBodyConverter TEXT_WILDCARD = new MessageBodyConverter<Object>(){

        @Override
        public byte[] writeMessageBody(Object t) {
            return t.toString().getBytes(CharsetUtil.UTF_8);
        }

        @Override
        public Object readMessageBody(InputStream in, Class<Object> clazz) {
            return IOUtils.toString(in, CharsetUtil.UTF_8.name());
        }
    };
    public static final MessageBodyConverter PROTOBUF = new MessageBodyConverter<Message>(){

        @Override
        public byte[] writeMessageBody(Message t) {
            return t.toByteArray();
        }

        @Override
        public Message readMessageBody(InputStream in, Class<Message> type) {
            try {
                return (Message)ObjectSerializer.PROTOBUF.deserialize(in, type);
            }
            catch (Throwable ex) {
                throw new DoradoException(ex);
            }
        }
    };
    public static final MessageBodyConverter DEFAULT = new MessageBodyConverter<Object>(){

        @Override
        public byte[] writeMessageBody(Object t) {
            return SerializeUtils.serialize(t);
        }

        @Override
        public Object readMessageBody(InputStream in, Class<Object> clazz) {
            return SerializeUtils.deserialize(in, clazz);
        }
    };

    public byte[] writeMessageBody(T var1);

    public T readMessageBody(InputStream var1, Class<T> var2);
}

