/*
 * Decompiled with CFR 0.152.
 */
package mobi.f2time.dorado.rest;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import mobi.f2time.dorado.rest.MediaType;
import mobi.f2time.dorado.rest.MessageBodyConverter;

public class MessageBodyConverters {
    private static Map<MediaType, MessageBodyConverter> messageBodyConverterHolder = new ConcurrentHashMap<MediaType, MessageBodyConverter>();

    public static MessageBodyConverter getMessageBodyConverter(MediaType mediaType) {
        MessageBodyConverter messageBodyConverter = messageBodyConverterHolder.get(mediaType);
        return messageBodyConverter == null ? MessageBodyConverter.DEFAULT : messageBodyConverter;
    }

    static {
        messageBodyConverterHolder.put(MediaType.TEXT_HTML_TYPE, MessageBodyConverter.TEXT_WILDCARD);
        messageBodyConverterHolder.put(MediaType.TEXT_PLAIN_TYPE, MessageBodyConverter.TEXT_WILDCARD);
        messageBodyConverterHolder.put(MediaType.APPLICATION_JSON_TYPE, MessageBodyConverter.JSON);
        messageBodyConverterHolder.put(MediaType.APPLICATION_PROTOBUF_TYPE, MessageBodyConverter.PROTOBUF);
        messageBodyConverterHolder.put(MediaType.APPLICATION_OCTET_STREAM_TYPE, MessageBodyConverter.DEFAULT);
        messageBodyConverterHolder.put(MediaType.WILDCARD_TYPE, MessageBodyConverter.DEFAULT);
    }
}

