/*
 * Decompiled with CFR 0.152.
 */
package mobi.f2time.dorado.rest.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import mobi.f2time.dorado.exception.DoradoException;
import mobi.f2time.dorado.rest.http.HttpResponse;
import mobi.f2time.dorado.rest.http.impl.OutputStreamImpl;
import mobi.f2time.dorado.rest.http.impl.PrintWriterImpl;

public class HttpResponseImpl
implements HttpResponse {
    private FullHttpResponse originalHttpResponse;
    private OutputStreamImpl out;
    private PrintWriterImpl writer;

    public HttpResponseImpl(FullHttpResponse response) {
        this.originalHttpResponse = response;
    }

    @Override
    public void setHeader(String name, String value) {
        this.originalHttpResponse.headers().set(name, (Object)value);
    }

    @Override
    public void addHeader(String name, String value) {
        this.originalHttpResponse.headers().add(name, (Object)value);
    }

    @Override
    public void sendRedirect(String location) {
        this.originalHttpResponse.setStatus(HttpResponseStatus.FOUND);
        this.originalHttpResponse.headers().set((CharSequence)HttpHeaderNames.LOCATION, (Object)location);
    }

    @Override
    public void sendError(int sc, String msg) {
        this.originalHttpResponse.setStatus(HttpResponseStatus.valueOf((int)sc, (String)msg));
    }

    @Override
    public void sendError(int sc) {
        this.originalHttpResponse.setStatus(HttpResponseStatus.valueOf((int)sc));
    }

    @Override
    public void setStatus(int sc) {
        this.originalHttpResponse.setStatus(HttpResponseStatus.valueOf((int)sc));
    }

    @Override
    public OutputStreamImpl getOutputStream() throws IOException {
        return this.out;
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        return this.writer;
    }

    @Override
    public void write(byte[] content) {
        this.originalHttpResponse.content().writeBytes(content);
    }

    @Override
    public void writeStringUtf8(String str) {
        ByteBufUtil.writeUtf8((ByteBuf)this.originalHttpResponse.content(), (CharSequence)str);
    }

    @Override
    public void write(InputStream in) {
        try {
            this.originalHttpResponse.content().writeBytes(in, in.available());
        }
        catch (IOException ex) {
            throw new DoradoException(ex);
        }
    }
}

