/*
 * Decompiled with CFR 0.152.
 */
package mobi.f2time.dorado.rest.router;

import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import mobi.f2time.dorado.rest.router.UriRoutingController;

public class UriRoutingMatchResult {
    private final UriRoutingController controller;
    private final String[] pathVariables;

    private UriRoutingMatchResult(UriRoutingController controller, MatchResult matchResult) {
        this.controller = controller;
        this.pathVariables = new String[matchResult.groupCount()];
        for (int i = 0; i < this.pathVariables.length; ++i) {
            this.pathVariables[i] = matchResult.group(i + 1);
        }
    }

    public static UriRoutingMatchResult create(UriRoutingController controller, Matcher matchResult) {
        return new UriRoutingMatchResult(controller, matchResult);
    }

    public UriRoutingController controller() {
        return this.controller;
    }

    public String pathVariable(int index) {
        if (index <= 0 || index > this.pathVariables.length) {
            throw new IllegalArgumentException("");
        }
        return this.pathVariables[index - 1];
    }

    public String[] pathVariables() {
        return this.pathVariables;
    }
}

