/*
 * Decompiled with CFR 0.152.
 */
package mobi.f2time.dorado.rest.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import mobi.f2time.dorado.rest.util.ClassLoaderUtils;

public final class FileUtils {
    public static List<File> listFiles(File dir, String suffix, boolean recursive) {
        File[] childrenFiles;
        ArrayList<File> files = new ArrayList<File>();
        if (!dir.isDirectory()) {
            return files;
        }
        for (File childFile : childrenFiles = dir.listFiles(f -> f.isDirectory() || f.isFile() && f.getName().endsWith(suffix))) {
            if (childFile.isFile()) {
                files.add(childFile);
            }
            files.addAll(FileUtils.listFiles(childFile, suffix, recursive));
        }
        return files;
    }

    public static List<Path> recurseListDirs(Path root) throws IOException {
        ArrayList<Path> results = new ArrayList<Path>();
        try (Stream<Path> pathStream = Files.walk(root, new FileVisitOption[0]);){
            pathStream.filter(p -> p.toFile().isDirectory()).forEach(p -> results.add((Path)p));
        }
        return results;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(FileUtils.recurseListDirs(Paths.get(ClassLoaderUtils.getPath(""), new String[0])));
    }
}

