/*
 * Decompiled with CFR 0.152.
 */
package mobi.f2time.dorado.rest.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import mobi.f2time.dorado.rest.util.LogUtils;

public class IOUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    private IOUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(InputStream in) {
        StringWriter writer = new StringWriter();
        InputStreamReader inputStreamReader = new InputStreamReader(in);
        try {
            IOUtils.copyLarge(inputStreamReader, writer);
            String string = writer.toString();
            return string;
        }
        catch (IOException ex) {
            LogUtils.error("", ex);
        }
        finally {
            IOUtils.closeQuietly(inputStreamReader);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String toString(InputStream in, String encoding) {
        String string;
        if (encoding == null) {
            return IOUtils.toString(in);
        }
        StringWriter writer = new StringWriter();
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(in, encoding);
            IOUtils.copyLarge(reader, writer);
            string = writer.toString();
        }
        catch (IOException ex) {
            try {
                LogUtils.error("", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
            IOUtils.closeQuietly(reader);
            return null;
        }
        IOUtils.closeQuietly(reader);
        return string;
    }

    public static void closeQuietly(Reader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Writer writer) {
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(InputStream in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(OutputStream out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static long copyLarge(Reader input, Writer output) throws IOException {
        char[] buffer = new char[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static byte[] readBytes(InputStream input) {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int n = 0;
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
            }
            return output.toByteArray();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

