/*
 * Decompiled with CFR 0.152.
 */
package mobi.f2time.dorado.rest.util;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import mobi.f2time.dorado.exception.DoradoException;

public class ProtobufMessageDescriptors {
    private static final Map<Class<?>, ProtobufMessageDescriptor> messageDescriptorHolder = new ConcurrentHashMap();

    public static void registerMessageDescriptor(ProtobufMessageDescriptor messageDescriptor) {
        messageDescriptorHolder.put(messageDescriptor.messageType, messageDescriptor);
    }

    public static ProtobufMessageDescriptor messageDescriptorForType(Class<?> type) {
        return messageDescriptorHolder.get(type);
    }

    public static void registerMessageDescriptorForType(Class<?> type) {
        messageDescriptorHolder.put(type, new ProtobufMessageDescriptor(type));
    }

    public static Message newMessageForType(byte[] data, Class<?> type) {
        ProtobufMessageDescriptor messageDescriptor = messageDescriptorHolder.get(type);
        if (messageDescriptor == null) {
            return null;
        }
        return messageDescriptor.mergeFrom(data);
    }

    public static Message newMessageForType(InputStream in, Class<?> type) {
        ProtobufMessageDescriptor messageDescriptor = messageDescriptorHolder.get(type);
        if (messageDescriptor == null) {
            return null;
        }
        return messageDescriptor.mergeFrom(in);
    }

    public static class ProtobufMessageDescriptor {
        private static final String METHOD_GET_DEFAULT_INSTANCE = "getDefaultInstance";
        private Class<?> messageType;
        private Message defaultMessageInstance;

        public ProtobufMessageDescriptor(Class<?> messageType) throws DoradoException {
            this.messageType = messageType;
            try {
                Method method = messageType.getMethod(METHOD_GET_DEFAULT_INSTANCE, null);
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                this.defaultMessageInstance = (Message)method.invoke(messageType, (Object[])null);
            }
            catch (Throwable ex) {
                throw new DoradoException(ex);
            }
        }

        public Message mergeFrom(byte[] data) {
            try {
                return this.defaultMessageInstance.newBuilderForType().mergeFrom(data).build();
            }
            catch (InvalidProtocolBufferException ex) {
                throw new DoradoException(ex);
            }
        }

        public Message mergeFrom(InputStream in) {
            try {
                return this.defaultMessageInstance.newBuilderForType().mergeFrom(in).build();
            }
            catch (IOException ex) {
                throw new DoradoException(ex);
            }
        }

        public Class<?> getMessageType() {
            return this.messageType;
        }
    }
}

