/*
 * Decompiled with CFR 0.152.
 */
package mobi.f2time.dorado.rest.util;

public final class StringUtils {
    public static final String EMPTY = "";

    public static String defaultString(String str, String defaultStr) {
        if (StringUtils.isBlank(str)) {
            return defaultStr;
        }
        return str;
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static int toInt(String str) {
        if (StringUtils.isBlank(str)) {
            return 0;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static long toLong(String str) {
        if (StringUtils.isBlank(str)) {
            return 0L;
        }
        try {
            return Long.parseLong(str);
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public static float toFloat(String str) {
        if (StringUtils.isBlank(str)) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(str);
        }
        catch (Exception exception) {
            return 0.0f;
        }
    }

    public static double toDouble(String str) {
        if (StringUtils.isBlank(str)) {
            return 0.0;
        }
        try {
            return Double.parseDouble(str);
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public static boolean toBoolean(String str) {
        if (StringUtils.isBlank(str)) {
            return false;
        }
        try {
            return Boolean.valueOf(str);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static short toShort(String str) {
        if (StringUtils.isBlank(str)) {
            return 0;
        }
        try {
            return Short.parseShort(str);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static char toChar(String str) {
        if (StringUtils.isBlank(str)) {
            return '\u0000';
        }
        char[] chars = str.toCharArray();
        if (chars.length > 1) {
            throw new IllegalArgumentException("invalid char");
        }
        return chars[0];
    }
}

