/*
 * Decompiled with CFR 0.152.
 */
package mobi.f2time.dorado.rest.util;

import com.google.protobuf.Message;
import java.util.HashMap;
import java.util.Map;

public final class TypeUtils {
    private static final Map<Class<?>, Object> primitiveDefaultHolder = new HashMap();

    public static boolean isPrimitive(Class<?> type) {
        return type.isPrimitive();
    }

    public static boolean isWrapper(Class<?> type) {
        return type == Integer.class || type == Long.class || type == Short.class || type == Float.class || type == Double.class || type == Boolean.class || type == Character.class;
    }

    public static boolean isPrimitiveOrWrapper(Class<?> type) {
        return TypeUtils.isPrimitive(type) || TypeUtils.isWrapper(type);
    }

    public static boolean isSerializableType(Class<?> type) {
        return !TypeUtils.isPrimitive(type) && !TypeUtils.isWrapper(type) && type != String.class && type != byte[].class && type != Byte[].class;
    }

    public static Object primitiveDefault(Class<?> parameterType) {
        return primitiveDefaultHolder.get(parameterType);
    }

    public static boolean isProtobufMessage(Class<?> type) {
        try {
            return Message.class.isAssignableFrom(type);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    static {
        primitiveDefaultHolder.put(Integer.TYPE, 0);
        primitiveDefaultHolder.put(Long.TYPE, 0L);
        primitiveDefaultHolder.put(Short.TYPE, 0);
        primitiveDefaultHolder.put(Float.TYPE, Float.valueOf(0.0f));
        primitiveDefaultHolder.put(Byte.TYPE, (byte)0);
        primitiveDefaultHolder.put(Double.TYPE, 0.0);
        primitiveDefaultHolder.put(Boolean.TYPE, false);
        primitiveDefaultHolder.put(Character.TYPE, Character.valueOf('\u0000'));
    }
}

