/*
 * Decompiled with CFR 0.152.
 */
package mobi.f2time.dorado.rest;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import mobi.f2time.dorado.rest.MessageBodyConverter;
import mobi.f2time.dorado.rest.MessageBodyConverters;
import mobi.f2time.dorado.rest.http.Cookie;
import mobi.f2time.dorado.rest.http.HttpRequest;
import mobi.f2time.dorado.rest.http.HttpResponse;
import mobi.f2time.dorado.rest.util.MediaTypeUtils;
import mobi.f2time.dorado.rest.util.MethodDescriptor;
import mobi.f2time.dorado.rest.util.TypeConverter;
import mobi.f2time.dorado.rest.util.TypeConverters;
import mobi.f2time.dorado.rest.util.TypeUtils;

public interface ParameterValueResolver {
    public static final ParameterValueResolver REQUEST_PARAM = (req, resp, methodDesc, methodParam, pathVariable) -> TypeConverters.resolveConverter(methodParam.getType()).convert(req.getParameter(methodParam.getName()));
    public static final ParameterValueResolver HEADER_PARAM = (req, resp, methodDesc, methodParam, pathVariable) -> TypeConverters.resolveConverter(methodParam.getType()).convert(req.getHeader(methodParam.getName()));
    public static final ParameterValueResolver PATH_PARAM = (req, resp, methodDesc, methodParam, pathVariable) -> TypeConverters.resolveConverter(methodParam.getType()).convert(pathVariable);
    public static final ParameterValueResolver HTTP_REQUEST = (req, resp, methodDesc, methodParam, pathVariable) -> TypeConverter.DUMMY.convert(req);
    public static final ParameterValueResolver HTTP_RESPONSE = (req, resp, methodDesc, methodParam, pathVariable) -> TypeConverter.DUMMY.convert(resp);
    public static final ParameterValueResolver COOKIE_PARAM = (req, resp, methodDesc, methodParam, pathVariable) -> {
        Cookie[] cookies;
        for (Cookie cookie : cookies = req.getCookies()) {
            if (!methodParam.getName().equalsIgnoreCase(cookie.name())) continue;
            return TypeConverters.resolveConverter(methodParam.getType()).convert(cookie.value());
        }
        Class<?> parameterType = methodParam.getType();
        return parameterType.isPrimitive() ? TypeUtils.primitiveDefault(parameterType) : null;
    };
    public static final ParameterValueResolver REQUEST_BODY = (req, resp, methodDesc, methodParam, pathVariable) -> {
        Class<?> parameterType = methodParam.getType();
        InputStream payload = req.getInputStream();
        MessageBodyConverter converter = MessageBodyConverters.getMessageBodyConverter(MediaTypeUtils.defaultForType(parameterType, methodDesc.consume()));
        return converter.readMessageBody(payload, parameterType);
    };
    public static final ParameterValueResolver ALL = new ParameterValueResolver(){
        List<ParameterValueResolver> resolverList = new ArrayList<ParameterValueResolver>();
        {
            this.resolverList.add(REQUEST_PARAM);
            this.resolverList.add(PATH_PARAM);
            this.resolverList.add(HEADER_PARAM);
        }

        @Override
        public Object resolveParameterValue(HttpRequest request, HttpResponse response, MethodDescriptor desc, MethodDescriptor.MethodParameter methodParameter, String pathVariable) {
            Class<?> parameterType = methodParameter.getType();
            for (ParameterValueResolver valueResolver : this.resolverList) {
                Object parameterValue = valueResolver.resolveParameterValue(request, response, desc, methodParameter, pathVariable);
                if (parameterValue == null) continue;
                return parameterValue;
            }
            if (parameterType.isPrimitive()) {
                return TypeUtils.primitiveDefault(parameterType);
            }
            return REQUEST_BODY.resolveParameterValue(request, response, desc, methodParameter, pathVariable);
        }
    };

    public Object resolveParameterValue(HttpRequest var1, HttpResponse var2, MethodDescriptor var3, MethodDescriptor.MethodParameter var4, String var5);
}

