/*
 * Decompiled with CFR 0.152.
 */
package mobi.f2time.dorado.rest.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.concurrent.GenericFutureListener;
import mobi.f2time.dorado.Dorado;
import mobi.f2time.dorado.rest.controller.DoradoStatus;
import mobi.f2time.dorado.rest.http.impl.ChannelHolder;
import mobi.f2time.dorado.rest.http.impl.HttpRequestImpl;
import mobi.f2time.dorado.rest.http.impl.HttpResponseImpl;
import mobi.f2time.dorado.rest.http.impl.Webapp;
import mobi.f2time.dorado.rest.router.UriRoutingMatchResult;
import mobi.f2time.dorado.rest.server.DoradoServerBuilder;
import mobi.f2time.dorado.rest.util.LogUtils;
import mobi.f2time.dorado.rest.util.TracingThreadPoolExecutor;

public class DoradoServerHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private final TracingThreadPoolExecutor asyncExecutor;
    private final Webapp webapp = Webapp.get();
    private final DoradoStatus status;
    private final boolean isDevMode;

    private DoradoServerHandler(DoradoServerBuilder builder) {
        this.asyncExecutor = builder.executor();
        this.status = DoradoStatus.get();
        this.isDevMode = builder.isDevMode();
    }

    public static DoradoServerHandler create(DoradoServerBuilder builder) {
        return new DoradoServerHandler(builder);
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest msg) throws Exception {
        this.status.totalRequestsIncrement();
        if (this.asyncExecutor == null) {
            this.handleHttpRequest(ctx, msg);
            return;
        }
        this.asyncExecutor.execute(() -> this.handleHttpRequest(ctx, msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleHttpRequest(ChannelHandlerContext ctx, Object msg) {
        if (this.isDevMode) {
            Thread.currentThread().setContextClassLoader(Dorado.classLoader);
        }
        FullHttpRequest request = (FullHttpRequest)msg;
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(request.protocolVersion(), HttpResponseStatus.OK);
        boolean isKeepAlive = HttpUtil.isKeepAlive((HttpMessage)request);
        HttpUtil.setKeepAlive((HttpMessage)response, (boolean)isKeepAlive);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html;charset=UTF-8");
        response.headers().set((CharSequence)HttpHeaderNames.SERVER, (Object)"dorado_1.x");
        ChannelFuture channelFuture = null;
        try {
            ChannelHolder.set(ctx.channel());
            HttpRequestImpl _request = new HttpRequestImpl(request);
            HttpResponseImpl _response = new HttpResponseImpl((FullHttpResponse)response);
            UriRoutingMatchResult uriRouting = this.webapp.getUriRoutingRegistry().findRouteController(_request);
            if (uriRouting == null) {
                response.setStatus(HttpResponseStatus.NOT_FOUND);
                ByteBufUtil.writeUtf8((ByteBuf)response.content(), (CharSequence)String.format("Resource not found, url: [%s], http_method: [%s]", request.uri(), _request.getMethod()));
            } else {
                String[] pathVariables = uriRouting.pathVariables();
                uriRouting.controller().invoke(_request, _response, pathVariables);
            }
        }
        catch (Throwable ex) {
            LogUtils.error("handle http request error", ex);
            response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            ByteBufUtil.writeUtf8((ByteBuf)response.content(), (CharSequence)"500 Internal Server Error");
        }
        finally {
            ChannelHolder.unset();
            if (isKeepAlive) {
                HttpUtil.setContentLength((HttpMessage)response, (long)response.content().readableBytes());
            }
            channelFuture = ctx.channel().writeAndFlush((Object)response);
            if (!isKeepAlive && channelFuture != null) {
                channelFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
            this.status.handledRequestsIncrement();
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        IdleStateEvent e;
        if (evt instanceof IdleStateEvent && (e = (IdleStateEvent)evt) == IdleStateEvent.READER_IDLE_STATE_EVENT) {
            ctx.channel().close();
        }
        super.userEventTriggered(ctx, evt);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.status.connectionIncrement();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.status.connectionDecrement();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LogUtils.error(cause.getMessage(), cause);
        ctx.channel().close();
    }
}

